/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.InjectEnhancementWorker;
import org.apache.tapestry.services.ComponentPropertySource;
import org.apache.tapestry.spec.InjectSpecification;

public class InjectMetaWorker
implements InjectEnhancementWorker {
    static final String SOURCE_NAME = "_$componentPropertySource";
    private ComponentPropertySource _source;
    private ValueConverter _valueConverter;
    private Map _primitiveParser = new HashMap();
    static /* synthetic */ Class class$org$apache$tapestry$services$ComponentPropertySource;
    static /* synthetic */ Class class$org$apache$tapestry$coerce$ValueConverter;

    public InjectMetaWorker() {
        this._primitiveParser.put(Boolean.TYPE, "java.lang.Boolean.parseBoolean");
        this._primitiveParser.put(Short.TYPE, "java.lang.Short.parseShort");
        this._primitiveParser.put(Integer.TYPE, "java.lang.Integer.parseInt");
        this._primitiveParser.put(Long.TYPE, "java.lang.Long.parseLong");
        this._primitiveParser.put(Double.TYPE, "java.lang.Double.parseDouble");
        this._primitiveParser.put(Float.TYPE, "java.lang.Float.parseFloat");
    }

    public void performEnhancement(EnhancementOperation op, InjectSpecification spec) {
        String propertyName = spec.getProperty();
        String metaKey = spec.getObject();
        this.injectMetaValue(op, propertyName, metaKey, spec.getLocation());
    }

    public void injectMetaValue(EnhancementOperation op, String propertyName, String metaKey, Location location) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Defense.notNull((Object)metaKey, (String)"metaKey");
        Class propertyType = op.getPropertyType(propertyName);
        op.claimReadonlyProperty(propertyName);
        String sourceName = op.addInjectedField(SOURCE_NAME, class$org$apache$tapestry$services$ComponentPropertySource == null ? (class$org$apache$tapestry$services$ComponentPropertySource = InjectMetaWorker.class$("org.apache.tapestry.services.ComponentPropertySource")) : class$org$apache$tapestry$services$ComponentPropertySource, this._source);
        MethodSignature sig = new MethodSignature(propertyType, op.getAccessorMethodName(propertyName), null, null);
        String parser = (String)this._primitiveParser.get(propertyType);
        if (parser != null) {
            this.addPrimitive(op, metaKey, propertyName, sig, sourceName, parser, location);
            return;
        }
        if (propertyType == Character.TYPE) {
            this.addCharacterPrimitive(op, metaKey, propertyName, sig, sourceName, location);
            return;
        }
        this.addObject(op, metaKey, propertyName, propertyType, sig, sourceName, location);
    }

    private void addPrimitive(EnhancementOperation op, String metaKey, String propertyName, MethodSignature sig, String sourceName, String parser, Location location) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("java.lang.String meta = {0}.getComponentProperty(this, \"{1}\");", (Object)sourceName, (Object)metaKey);
        builder.addln("return {0}(meta);", (Object)parser);
        builder.end();
        op.addMethod(1, sig, builder.toString(), location);
    }

    private void addCharacterPrimitive(EnhancementOperation op, String metaKey, String propertyName, MethodSignature sig, String sourceName, Location location) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("java.lang.String meta = {0}.getComponentProperty(this, \"{1}\");", (Object)sourceName, (Object)metaKey);
        builder.addln("return meta.charAt(0);");
        builder.end();
        op.addMethod(1, sig, builder.toString(), location);
    }

    private void addObject(EnhancementOperation op, String metaKey, String propertyName, Class propertyType, MethodSignature sig, String sourceName, Location location) {
        String valueConverterName = op.addInjectedField("_$valueConverter", class$org$apache$tapestry$coerce$ValueConverter == null ? (class$org$apache$tapestry$coerce$ValueConverter = InjectMetaWorker.class$("org.apache.tapestry.coerce.ValueConverter")) : class$org$apache$tapestry$coerce$ValueConverter, this._valueConverter);
        String classRef = op.getClassReference(propertyType);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("java.lang.String meta = {0}.getComponentProperty(this, \"{1}\");", (Object)sourceName, (Object)metaKey);
        builder.addln("return ({0}) {1}.coerceValue(meta, {2});", (Object)ClassFabUtils.getJavaClassName((Class)propertyType), (Object)valueConverterName, (Object)classRef);
        builder.end();
        op.addMethod(1, sig, builder.toString(), location);
    }

    public void setSource(ComponentPropertySource source) {
        this._source = source;
    }

    public void setValueConverter(ValueConverter valueConverter) {
        this._valueConverter = valueConverter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

