/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ContextResource;
import org.apache.tapestry.parse.ISpecificationParser;
import org.apache.tapestry.services.ApplicationGlobals;
import org.apache.tapestry.services.ApplicationInitializer;
import org.apache.tapestry.services.ClasspathResourceFactory;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.spec.ApplicationSpecification;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.web.HttpServletWebActivator;

public class ApplicationSpecificationInitializer
implements ApplicationInitializer {
    private Log _log;
    private ClasspathResourceFactory _classpathResourceFactory;
    private ApplicationGlobals _globals;
    private ISpecificationParser _parser;
    public static final String APP_SPEC_PATH_PARAM = "org.apache.tapestry.application-specification";

    public void initialize(HttpServlet servlet) {
        IApplicationSpecification spec = null;
        Resource specResource = this.findApplicationSpecification(servlet);
        if (specResource == null) {
            this._log.debug((Object)ImplMessages.noApplicationSpecification(servlet));
            spec = this.constructStandinSpecification(servlet);
        } else {
            spec = this._parser.parseApplicationSpecification(specResource);
        }
        this._globals.storeActivator(new HttpServletWebActivator(servlet));
        this._globals.storeSpecification(spec);
    }

    private Resource findApplicationSpecification(HttpServlet servlet) {
        String path = servlet.getInitParameter(APP_SPEC_PATH_PARAM);
        if (path != null) {
            return this._classpathResourceFactory.newResource(path);
        }
        ServletContext context = servlet.getServletContext();
        String servletName = servlet.getServletName();
        String expectedName = servletName + ".application";
        ContextResource webInfLocation = new ContextResource(context, "/WEB-INF/");
        Resource webInfAppLocation = webInfLocation.getRelativeResource(servletName + "/");
        Resource result = this.check(webInfAppLocation, expectedName);
        if (result != null) {
            return result;
        }
        return this.check((Resource)webInfLocation, expectedName);
    }

    private Resource check(Resource resource, String name) {
        Resource result = resource.getRelativeResource(name);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Checking for existence of " + result));
        }
        if (result.getResourceURL() != null) {
            this._log.debug((Object)("Found " + result));
            return result;
        }
        return null;
    }

    private IApplicationSpecification constructStandinSpecification(HttpServlet servlet) {
        String servletName = servlet.getServletName();
        ApplicationSpecification result = new ApplicationSpecification();
        ContextResource virtualLocation = new ContextResource(servlet.getServletContext(), "/WEB-INF/" + servletName + ".application");
        result.setSpecificationLocation((Resource)virtualLocation);
        result.setName(servletName);
        return result;
    }

    public void setClasspathResourceFactory(ClasspathResourceFactory factory) {
        this._classpathResourceFactory = factory;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void setGlobals(ApplicationGlobals globals) {
        this._globals = globals;
    }

    public void setParser(ISpecificationParser parser) {
        this._parser = parser;
    }
}

