/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tapestry.services.CookieSource;

public class CookieSourceImpl
implements CookieSource {
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private int _defaultMaxAge;

    public String readCookieValue(String name) {
        Cookie[] cookies = this._request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public void writeCookieValue(String name, String value) {
        this.writeCookieValue(name, value, this._defaultMaxAge);
    }

    public void writeCookieValue(String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this._request.getContextPath() + "/");
        cookie.setMaxAge(maxAge);
        this._response.addCookie(cookie);
    }

    public void removeCookieValue(String name) {
        Cookie cookie = new Cookie(name, null);
        cookie.setPath(this._request.getContextPath() + "/");
        cookie.setMaxAge(0);
        this._response.addCookie(cookie);
    }

    public void setRequest(HttpServletRequest request) {
        this._request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this._response = response;
    }

    public void setDefaultMaxAge(int defaultMaxAge) {
        this._defaultMaxAge = defaultMaxAge;
    }
}

