/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Location;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.service.ObjectProvider;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.services.impl.ImplMessages;

public class InfrastructureObjectProvider
implements ObjectProvider {
    private ErrorLog _errorLog;
    private Infrastructure _infrastructure;
    private Map _cache = new HashMap();

    public synchronized Object provideObject(Module contributingModule, Class propertyType, String locator, Location location) {
        Object result = this._cache.get(locator);
        if (result == null) {
            result = this.readProperty(locator, location);
            this._cache.put(locator, result);
        }
        return result;
    }

    Object readProperty(String locator, Location location) {
        try {
            if (PropertyUtils.isReadable((Object)this._infrastructure, (String)locator)) {
                return PropertyUtils.read((Object)this._infrastructure, (String)locator);
            }
            return this._infrastructure.getProperty(locator);
        }
        catch (Throwable ex) {
            this._errorLog.error(ImplMessages.unableToReadInfrastructureProperty(locator, this._infrastructure, ex), location, ex);
            return null;
        }
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void setInfrastructure(Infrastructure infrastructure) {
        this._infrastructure = infrastructure;
    }
}

