/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorLog;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.services.ServiceMap;
import org.apache.tapestry.services.impl.EngineServiceContribution;
import org.apache.tapestry.services.impl.EngineServiceInnerProxy;
import org.apache.tapestry.services.impl.EngineServiceOuterProxy;
import org.apache.tapestry.services.impl.EngineServiceSource;
import org.apache.tapestry.services.impl.ImplMessages;

public class ServiceMapImpl
implements ServiceMap,
EngineServiceSource {
    private List _applicationServices;
    private List _factoryServices;
    private ErrorLog _errorLog;
    private Map _services;
    private Map _proxies = new HashMap();

    public void initializeService() {
        Map factoryMap = this.buildServiceMap(this._factoryServices);
        Map applicationMap = this.buildServiceMap(this._applicationServices);
        factoryMap.putAll(applicationMap);
        this._services = factoryMap;
    }

    private Map buildServiceMap(List services) {
        HashMap<String, EngineServiceContribution> result = new HashMap<String, EngineServiceContribution>();
        Iterator i = services.iterator();
        while (i.hasNext()) {
            EngineServiceContribution contribution = (EngineServiceContribution)((Object)i.next());
            String name = contribution.getName();
            EngineServiceContribution existing = (EngineServiceContribution)((Object)result.get(name));
            if (existing != null) {
                this._errorLog.error(ImplMessages.dupeService(name, existing), existing.getLocation(), null);
                continue;
            }
            result.put(name, contribution);
        }
        return result;
    }

    public synchronized IEngineService getService(String name) {
        IEngineService result = (IEngineService)this._proxies.get(name);
        if (result == null) {
            result = this.buildProxy(name);
            this._proxies.put(name, result);
        }
        return result;
    }

    public boolean isValid(String name) {
        return this._services.containsKey(name);
    }

    public IEngineService resolveEngineService(String name) {
        EngineServiceContribution contribution = (EngineServiceContribution)((Object)this._services.get(name));
        if (contribution == null) {
            throw new ApplicationRuntimeException(ImplMessages.noSuchService(name));
        }
        IEngineService service = contribution.getService();
        String serviceName = service.getName();
        if (!name.equals(serviceName)) {
            throw new ApplicationRuntimeException(ImplMessages.serviceNameMismatch(service, name, serviceName), contribution.getLocation(), null);
        }
        return service;
    }

    private IEngineService buildProxy(String name) {
        if (!this._services.containsKey(name)) {
            throw new ApplicationRuntimeException(ImplMessages.noSuchService(name));
        }
        EngineServiceOuterProxy outer = new EngineServiceOuterProxy(name);
        EngineServiceInnerProxy inner = new EngineServiceInnerProxy(name, outer, this);
        outer.installDelegate(inner);
        return outer;
    }

    public void setApplicationServices(List applicationServices) {
        this._applicationServices = applicationServices;
    }

    public void setFactoryServices(List factoryServices) {
        this._factoryServices = factoryServices;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

