/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Resource;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.ITemplateSourceDelegate;
import org.apache.tapestry.event.ReportStatusEvent;
import org.apache.tapestry.event.ReportStatusListener;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.l10n.ResourceLocalizer;
import org.apache.tapestry.parse.ComponentTemplate;
import org.apache.tapestry.parse.ITemplateParser;
import org.apache.tapestry.parse.TemplateParseException;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.parse.TextToken;
import org.apache.tapestry.parse.TokenType;
import org.apache.tapestry.resolver.ComponentSpecificationResolver;
import org.apache.tapestry.services.ComponentPropertySource;
import org.apache.tapestry.services.TemplateSource;
import org.apache.tapestry.services.impl.DefaultParserDelegate;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.MultiKey;

public class TemplateSourceImpl
implements TemplateSource,
ResetEventListener,
ReportStatusListener {
    private String _serviceId;
    private Log _log;
    public static final String TEMPLATE_ENCODING_PROPERTY_NAME = "org.apache.tapestry.template-encoding";
    private Map _cache = Collections.synchronizedMap(new HashMap());
    private Map _templates = Collections.synchronizedMap(new HashMap());
    private static final int BUFFER_SIZE = 2000;
    private ITemplateParser _parser;
    private Resource _contextRoot;
    private ITemplateSourceDelegate _delegate;
    private ComponentSpecificationResolver _componentSpecificationResolver;
    private ComponentPropertySource _componentPropertySource;
    private ResourceLocalizer _localizer;

    public void resetEventDidOccur() {
        this._cache.clear();
        this._templates.clear();
    }

    public void reportStatus(ReportStatusEvent event) {
        event.title(this._serviceId);
        int templateCount = 0;
        int tokenCount = 0;
        int characterCount = 0;
        Iterator<Object> i = this._templates.values().iterator();
        while (i.hasNext()) {
            ComponentTemplate template = (ComponentTemplate)i.next();
            ++templateCount;
            int count = template.getTokenCount();
            tokenCount += count;
            for (int j = 0; j < count; ++j) {
                TemplateToken token = template.getToken(j);
                if (token.getType() != TokenType.TEXT) continue;
                TextToken tt = (TextToken)token;
                characterCount += tt.getLength();
            }
        }
        event.property("parsed templates", templateCount);
        event.property("total template tokens", tokenCount);
        event.property("total template characters", characterCount);
        event.section("Parsed template token counts");
        i = this._templates.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String key = entry.getKey().toString();
            ComponentTemplate template = (ComponentTemplate)entry.getValue();
            event.property(key, template.getTokenCount());
        }
    }

    public ComponentTemplate getTemplate(IRequestCycle cycle, IComponent component) {
        Locale locale;
        IComponentSpecification specification = component.getSpecification();
        Resource resource = specification.getSpecificationLocation();
        MultiKey key = new MultiKey(new Object[]{resource, locale = component.getPage().getLocale()}, false);
        ComponentTemplate result = this.searchCache(key);
        if (result != null) {
            return result;
        }
        result = this.findTemplate(cycle, resource, component, locale);
        if (result == null) {
            result = this._delegate.findTemplate(cycle, component, locale);
            if (result != null) {
                return result;
            }
            String message = component.getSpecification().isPageSpecification() ? ImplMessages.noTemplateForPage(component.getExtendedId(), locale) : ImplMessages.noTemplateForComponent(component.getExtendedId(), locale);
            throw new ApplicationRuntimeException(message, (Object)component, component.getLocation(), null);
        }
        this.saveToCache(key, result);
        return result;
    }

    private ComponentTemplate searchCache(Object key) {
        return (ComponentTemplate)this._cache.get(key);
    }

    private void saveToCache(Object key, ComponentTemplate template) {
        this._cache.put(key, template);
    }

    private ComponentTemplate findTemplate(IRequestCycle cycle, Resource resource, IComponent component, Locale locale) {
        IAsset templateAsset = component.getAsset("$template");
        if (templateAsset != null) {
            return this.readTemplateFromAsset(cycle, component, templateAsset);
        }
        String name = resource.getName();
        int dotx = name.lastIndexOf(46);
        String templateExtension = this.getTemplateExtension(component);
        String templateBaseName = name.substring(0, dotx + 1) + templateExtension;
        ComponentTemplate result = this.findStandardTemplate(cycle, resource, component, templateBaseName, locale);
        if (result == null && component.getSpecification().isPageSpecification() && component.getNamespace().isApplicationNamespace()) {
            result = this.findPageTemplateInApplicationRoot(cycle, (IPage)component, templateExtension, locale);
        }
        return result;
    }

    private ComponentTemplate findPageTemplateInApplicationRoot(IRequestCycle cycle, IPage page, String templateExtension, Locale locale) {
        Resource baseLocation;
        Resource localizedLocation;
        String templateBaseName = page.getPageName() + "." + templateExtension;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Checking for " + templateBaseName + " in application root"));
        }
        if ((localizedLocation = this._localizer.findLocalization(baseLocation = this._contextRoot.getRelativeResource(templateBaseName), locale)) == null) {
            return null;
        }
        return this.getOrParseTemplate(cycle, localizedLocation, page);
    }

    private ComponentTemplate readTemplateFromAsset(IRequestCycle cycle, IComponent component, IAsset asset) {
        InputStream stream = asset.getResourceAsStream();
        char[] templateData = null;
        try {
            String encoding = this.getTemplateEncoding(component, null);
            templateData = this.readTemplateStream(stream, encoding);
            stream.close();
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToReadTemplate(asset), (Throwable)ex);
        }
        Resource resourceLocation = asset.getResourceLocation();
        return this.constructTemplateInstance(cycle, templateData, resourceLocation, component);
    }

    private ComponentTemplate findStandardTemplate(IRequestCycle cycle, Resource resource, IComponent component, String templateBaseName, Locale locale) {
        Resource baseTemplateLocation;
        Resource localizedTemplateLocation;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Searching for localized version of template for " + resource + " in locale " + locale.getDisplayName()));
        }
        if ((localizedTemplateLocation = this._localizer.findLocalization(baseTemplateLocation = resource.getRelativeResource(templateBaseName), locale)) == null) {
            return null;
        }
        return this.getOrParseTemplate(cycle, localizedTemplateLocation, component);
    }

    private ComponentTemplate getOrParseTemplate(IRequestCycle cycle, Resource resource, IComponent component) {
        ComponentTemplate result = (ComponentTemplate)this._templates.get(resource);
        if (result != null) {
            return result;
        }
        result = this.parseTemplate(cycle, resource, component);
        if (result != null) {
            this._templates.put(resource, result);
        }
        return result;
    }

    private ComponentTemplate parseTemplate(IRequestCycle cycle, Resource resource, IComponent component) {
        String encoding = this.getTemplateEncoding(component, resource.getLocale());
        char[] templateData = this.readTemplate(resource, encoding);
        if (templateData == null) {
            return null;
        }
        return this.constructTemplateInstance(cycle, templateData, resource, component);
    }

    private synchronized ComponentTemplate constructTemplateInstance(IRequestCycle cycle, char[] templateData, Resource resource, IComponent component) {
        TemplateToken[] tokens;
        String componentAttributeName = this._componentPropertySource.getComponentProperty(component, "org.apache.tapestry.jwcid-attribute-name");
        DefaultParserDelegate delegate = new DefaultParserDelegate(component, componentAttributeName, cycle, this._componentSpecificationResolver);
        try {
            tokens = this._parser.parse(templateData, delegate, resource);
        }
        catch (TemplateParseException ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToParseTemplate(resource), (Throwable)ex);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Parsed " + tokens.length + " tokens from template"));
        }
        return new ComponentTemplate(templateData, tokens);
    }

    private char[] readTemplate(Resource resource, String encoding) {
        URL url;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Reading template " + resource));
        }
        if ((url = resource.getResourceURL()) == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"Template does not exist.");
            }
            return null;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Reading template from URL " + url));
        }
        InputStream stream = null;
        try {
            stream = url.openStream();
            char[] cArray = this.readTemplateStream(stream, encoding);
            return cArray;
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToReadTemplate(resource), (Throwable)ex);
        }
        finally {
            Tapestry.close(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] readTemplateStream(InputStream stream, String encoding) throws IOException {
        char[] charBuffer = new char[2000];
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = encoding != null ? new InputStreamReader((InputStream)new BufferedInputStream(stream), encoding) : new InputStreamReader(new BufferedInputStream(stream));
        try {
            int charsRead;
            while ((charsRead = reader.read(charBuffer, 0, 2000)) > 0) {
                buffer.append(charBuffer, 0, charsRead);
            }
        }
        finally {
            reader.close();
        }
        int length = buffer.length();
        charBuffer = new char[length];
        buffer.getChars(0, length, charBuffer, 0);
        return charBuffer;
    }

    private String getTemplateExtension(IComponent component) {
        return this._componentPropertySource.getComponentProperty(component, "org.apache.tapestry.template-extension");
    }

    private String getTemplateEncoding(IComponent component, Locale locale) {
        return this._componentPropertySource.getLocalizedComponentProperty(component, locale, TEMPLATE_ENCODING_PROPERTY_NAME);
    }

    public void setParser(ITemplateParser parser) {
        this._parser = parser;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void setDelegate(ITemplateSourceDelegate delegate) {
        this._delegate = delegate;
    }

    public void setComponentSpecificationResolver(ComponentSpecificationResolver resolver) {
        this._componentSpecificationResolver = resolver;
    }

    public void setContextRoot(Resource contextRoot) {
        this._contextRoot = contextRoot;
    }

    public void setComponentPropertySource(ComponentPropertySource componentPropertySource) {
        this._componentPropertySource = componentPropertySource;
    }

    public void setServiceId(String serviceId) {
        this._serviceId = serviceId;
    }

    public void setLocalizer(ResourceLocalizer localizer) {
        this._localizer = localizer;
    }
}

