/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.util.Defense;

public class IdAllocator {
    private static final String SEPARATOR = "_";
    private final Map _generatorMap = new HashMap();
    private final String _namespace;

    public IdAllocator() {
        this("");
    }

    public IdAllocator(String namespace) {
        Defense.notNull((Object)namespace, (String)"namespace");
        this._namespace = namespace;
    }

    public String allocateId(String name) {
        String key = name + this._namespace;
        NameGenerator g = (NameGenerator)this._generatorMap.get(key);
        String result = null;
        if (g == null) {
            g = new NameGenerator(key);
            result = key;
        } else {
            result = g.nextId();
        }
        while (this._generatorMap.containsKey(result)) {
            result = g.nextId();
        }
        this._generatorMap.put(result, g);
        return result;
    }

    public void clear() {
        this._generatorMap.clear();
    }

    private static class NameGenerator {
        private final String _baseId;
        private int _index;

        NameGenerator(String baseId) {
            this._baseId = baseId + IdAllocator.SEPARATOR;
        }

        public String nextId() {
            return this._baseId + this._index++;
        }
    }
}

