/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.text;

import org.apache.tapestry.util.text.AsciiCharacterMatcher;
import org.apache.tapestry.util.text.AsciiCharacterTranslator;
import org.apache.tapestry.util.text.ICharacterMatcher;
import org.apache.tapestry.util.text.ICharacterTranslator;

public class MarkupCharacterTranslator
implements ICharacterTranslator {
    private static final String SAFE_CHARACTERS = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\t\n\r !#$%'()*+,-./:;=?@[\\]^_`{|}~";
    private static final String[][] ENTITIES = new String[][]{{"\"", "&quot;"}, {"<", "&lt;"}, {">", "&gt;"}, {"&", "&amp;"}};
    private static final ICharacterMatcher SAFE_MATCHER = new AsciiCharacterMatcher("01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\t\n\r !#$%'()*+,-./:;=?@[\\]^_`{|}~");
    private static final ICharacterTranslator ENTITY_TRANSLATOR = new AsciiCharacterTranslator(ENTITIES);
    private boolean _encodeNonAscii;
    private ICharacterMatcher _safeMatcher;
    private ICharacterTranslator _entityTranslator;

    public MarkupCharacterTranslator() {
        this(true);
    }

    public MarkupCharacterTranslator(boolean encodeNonAscii) {
        this(encodeNonAscii, SAFE_MATCHER, ENTITY_TRANSLATOR);
    }

    public MarkupCharacterTranslator(boolean encodeNonAscii, ICharacterMatcher safeMatcher, ICharacterTranslator entityTranslator) {
        this._encodeNonAscii = encodeNonAscii;
        this._safeMatcher = safeMatcher;
        this._entityTranslator = entityTranslator;
    }

    public MarkupCharacterTranslator(boolean encodeNonAscii, String safeCharacters, String[][] entities) {
        this._encodeNonAscii = encodeNonAscii;
        this._safeMatcher = new AsciiCharacterMatcher(safeCharacters);
        this._entityTranslator = new AsciiCharacterTranslator(entities);
    }

    public String translate(char ch) {
        if (ch >= '\u00a0' && !this._encodeNonAscii) {
            return null;
        }
        if (this._safeMatcher.matches(ch)) {
            return null;
        }
        String entity = this._entityTranslator.translate(ch);
        if (entity != null) {
            return entity;
        }
        return "&#" + ch + ";";
    }
}

