/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.web.WebMessages;
import org.apache.tapestry.web.WebResponse;

public class ServletWebResponse
implements WebResponse {
    private static final Log DEFAULT_LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$web$ServletWebResponse == null ? (class$org$apache$tapestry$web$ServletWebResponse = ServletWebResponse.class$("org.apache.tapestry.web.ServletWebResponse")) : class$org$apache$tapestry$web$ServletWebResponse));
    private final Log _log;
    private final boolean _tomcatPatch;
    private final HttpServletResponse _servletResponse;
    private boolean _needsReset;
    private ContentType _printWriterContentType;
    static /* synthetic */ Class class$org$apache$tapestry$web$ServletWebResponse;

    public ServletWebResponse(HttpServletResponse response) {
        this(response, DEFAULT_LOG, Boolean.getBoolean("org.apache.tapestry.607-patch"));
    }

    ServletWebResponse(HttpServletResponse response, Log log, boolean tomcatPatch) {
        Defense.notNull((Object)response, (String)"response");
        Defense.notNull((Object)log, (String)"log");
        this._servletResponse = response;
        this._log = log;
        this._tomcatPatch = tomcatPatch;
    }

    public OutputStream getOutputStream(ContentType contentType) {
        Defense.notNull((Object)contentType, (String)"contentType");
        this._servletResponse.setContentType(contentType.getMimeType());
        try {
            return this._servletResponse.getOutputStream();
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(WebMessages.streamOpenError(contentType, ex), null, (Throwable)ex);
        }
    }

    public PrintWriter getPrintWriter(ContentType contentType) throws IOException {
        Defense.notNull((Object)contentType, (String)"contentType");
        if (this._needsReset) {
            this.reset();
        }
        this._needsReset = true;
        if (this._printWriterContentType == null || !this._tomcatPatch) {
            this._servletResponse.setContentType(contentType.toString());
            this._printWriterContentType = contentType;
        } else if (!this._printWriterContentType.equals(contentType)) {
            this._log.warn((Object)WebMessages.contentTypeUnchanged(this._printWriterContentType, contentType));
        }
        try {
            return this._servletResponse.getWriter();
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(WebMessages.writerOpenError(contentType, ex), null, (Throwable)ex);
        }
    }

    public String encodeURL(String url) {
        return this._servletResponse.encodeURL(url);
    }

    public void reset() {
        try {
            this._servletResponse.reset();
        }
        catch (IllegalStateException ex) {
            this._log.error((Object)WebMessages.resetFailed(ex), (Throwable)ex);
        }
    }

    public void setContentLength(int length) {
        this._servletResponse.setContentLength(length);
    }

    public String getNamespace() {
        return "";
    }

    public void setDateHeader(String name, long date) {
        this._servletResponse.setDateHeader(name, date);
    }

    public void setStatus(int status) {
        this._servletResponse.setStatus(status);
    }

    public void setHeader(String name, String value) {
        this._servletResponse.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this._servletResponse.setIntHeader(name, value);
    }

    public void sendError(int statusCode, String message) throws IOException {
        this._servletResponse.sendError(statusCode, message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

