/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.components;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.contrib.table.components.TableColumnModelSource;
import org.apache.tapestry.contrib.table.components.TableMessages;
import org.apache.tapestry.contrib.table.model.IAdvancedTableColumn;
import org.apache.tapestry.contrib.table.model.IAdvancedTableColumnSource;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableColumnModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumn;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnModel;
import org.apache.tapestry.services.ExpressionEvaluator;

public class TableColumnModelSourceImpl
implements TableColumnModelSource {
    private ExpressionEvaluator _expressionEvaluator;

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this._expressionEvaluator = expressionEvaluator;
    }

    public ITableColumnModel generateTableColumnModel(IAdvancedTableColumnSource objColumnSource, String strDesc, IComponent objComponent, IComponent objColumnSettingsContainer) {
        if (strDesc == null) {
            return null;
        }
        ArrayList<Object> arrColumns = new ArrayList<Object>();
        strDesc = strDesc.trim();
        boolean bFormColumns = false;
        while (strDesc.startsWith("*")) {
            strDesc = strDesc.substring(1);
            bFormColumns = true;
        }
        StringTokenizer objTokenizer = new StringTokenizer(strDesc, ",");
        while (objTokenizer.hasMoreTokens()) {
            String strToken = objTokenizer.nextToken().trim();
            if (strToken.startsWith("=")) {
                String strColumnExpression = strToken.substring(1);
                Object objColumn = this._expressionEvaluator.read((Object)objColumnSettingsContainer, strColumnExpression);
                if (!(objColumn instanceof ITableColumn)) {
                    throw new ApplicationRuntimeException(TableMessages.notAColumn(objComponent, strColumnExpression));
                }
                arrColumns.add(objColumn);
                continue;
            }
            boolean bSortable = true;
            if (strToken.startsWith("!")) {
                strToken = strToken.substring(1);
                bSortable = false;
            }
            StringTokenizer objColumnTokenizer = new StringTokenizer(strToken, ":");
            String strName = "";
            if (objColumnTokenizer.hasMoreTokens()) {
                strName = objColumnTokenizer.nextToken();
            }
            String strExpression = strName;
            if (objColumnTokenizer.hasMoreTokens()) {
                strExpression = objColumnTokenizer.nextToken();
            }
            String strDisplayName = strName;
            if (objColumnTokenizer.hasMoreTokens()) {
                strDisplayName = strExpression;
                strExpression = objColumnTokenizer.nextToken();
            }
            IAdvancedTableColumn objColumn = objColumnSource.generateTableColumn(strName, strDisplayName, bSortable, strExpression);
            if (bFormColumns) {
                objColumn.setColumnRendererSource(SimpleTableColumn.FORM_COLUMN_RENDERER_SOURCE);
            }
            if (objColumnSettingsContainer != null) {
                objColumn.loadSettings(objColumnSettingsContainer);
            }
            arrColumns.add(objColumn);
        }
        return new SimpleTableColumnModel(arrColumns);
    }
}

