/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.ModuleDescriptorProvider;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.ImplMessages;
import org.apache.hivemind.parse.ModuleDescriptor;
import org.apache.hivemind.parse.SubModuleDescriptor;
import org.apache.hivemind.parse.XmlResourceProcessor;
import org.apache.hivemind.util.URLResource;

public class XmlModuleDescriptorProvider
implements ModuleDescriptorProvider {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$hivemind$impl$XmlModuleDescriptorProvider == null ? (class$org$apache$hivemind$impl$XmlModuleDescriptorProvider = XmlModuleDescriptorProvider.class$("org.apache.hivemind.impl.XmlModuleDescriptorProvider")) : class$org$apache$hivemind$impl$XmlModuleDescriptorProvider));
    public static final String HIVE_MODULE_XML = "META-INF/hivemodule.xml";
    private List _resources = new ArrayList();
    private List _moduleDescriptors = new ArrayList();
    private ClassResolver _resolver;
    private ErrorHandler _errorHandler;
    private XmlResourceProcessor _processor;
    static /* synthetic */ Class class$org$apache$hivemind$impl$XmlModuleDescriptorProvider;

    public XmlModuleDescriptorProvider(ClassResolver resolver) {
        this(resolver, HIVE_MODULE_XML);
    }

    public XmlModuleDescriptorProvider(ClassResolver resolver, String resourcePath) {
        this._resolver = resolver;
        this._resources.addAll(this.getDescriptorResources(resourcePath, this._resolver));
    }

    public XmlModuleDescriptorProvider(ClassResolver resolver, Resource resource) {
        this._resolver = resolver;
        this._resources.add(resource);
    }

    public XmlModuleDescriptorProvider(ClassResolver resolver, List resources) {
        this._resolver = resolver;
        this._resources.addAll(resources);
    }

    private List getDescriptorResources(String resourcePath, ClassResolver resolver) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing modules visible to " + resolver));
        }
        ArrayList<URLResource> descriptors = new ArrayList<URLResource>();
        ClassLoader loader = resolver.getClassLoader();
        Enumeration<URL> e = null;
        try {
            e = loader.getResources(resourcePath);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToFindModules(resolver, ex), ex);
        }
        while (e.hasMoreElements()) {
            URL descriptorURL = e.nextElement();
            descriptors.add(new URLResource(descriptorURL));
        }
        return descriptors;
    }

    public List getModuleDescriptors(ErrorHandler handler) {
        this._errorHandler = handler;
        this._processor = this.getResourceProcessor(this._resolver, handler);
        Iterator i = this._resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            this.processResource(resource);
        }
        this._processor = null;
        this._errorHandler = null;
        return this._moduleDescriptors;
    }

    private void processResource(Resource resource) {
        try {
            ModuleDescriptor md = this._processor.processResource(resource);
            this._moduleDescriptors.add(md);
            this.processSubModules(md);
        }
        catch (RuntimeException ex) {
            this._errorHandler.error(LOG, ex.getMessage(), HiveMind.getLocation(ex), ex);
        }
    }

    private void processSubModules(ModuleDescriptor moduleDescriptor) {
        List subModules = moduleDescriptor.getSubModules();
        if (subModules == null) {
            return;
        }
        Iterator i = subModules.iterator();
        while (i.hasNext()) {
            SubModuleDescriptor smd = (SubModuleDescriptor)i.next();
            Resource descriptorResource = smd.getDescriptor();
            if (descriptorResource.getResourceURL() == null) {
                this._errorHandler.error(LOG, ImplMessages.subModuleDoesNotExist(descriptorResource), smd.getLocation(), null);
                continue;
            }
            this.processResource(smd.getDescriptor());
        }
    }

    protected XmlResourceProcessor getResourceProcessor(ClassResolver resolver, ErrorHandler handler) {
        return new XmlResourceProcessor(resolver, handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

