/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.service;

import java.text.MessageFormat;

public class BodyBuilder {
    private static final int DEFAULT_LENGTH = 200;
    private static final char QUOTE = '\"';
    private StringBuffer _buffer = new StringBuffer(200);
    private static final String INDENT = "  ";
    private int _nestingDepth = 0;
    private boolean _atNewLine = true;

    public void clear() {
        this._nestingDepth = 0;
        this._atNewLine = true;
        this._buffer.setLength(0);
    }

    public void add(String text) {
        this.indent();
        this._buffer.append(text);
    }

    public void add(String pattern, Object[] arguments) {
        this.add(MessageFormat.format(pattern, arguments));
    }

    public void add(String pattern, Object arg0) {
        this.add(pattern, new Object[]{arg0});
    }

    public void add(String pattern, Object arg0, Object arg1) {
        this.add(pattern, new Object[]{arg0, arg1});
    }

    public void add(String pattern, Object arg0, Object arg1, Object arg2) {
        this.add(pattern, new Object[]{arg0, arg1, arg2});
    }

    public void addln(String pattern, Object[] arguments) {
        this.addln(MessageFormat.format(pattern, arguments));
    }

    public void addln(String pattern, Object arg0) {
        this.addln(pattern, new Object[]{arg0});
    }

    public void addln(String pattern, Object arg0, Object arg1) {
        this.addln(pattern, new Object[]{arg0, arg1});
    }

    public void addln(String pattern, Object arg0, Object arg1, Object arg2) {
        this.addln(pattern, new Object[]{arg0, arg1, arg2});
    }

    public void addQuoted(String text) {
        this.indent();
        this._buffer.append('\"');
        this._buffer.append(text);
        this._buffer.append('\"');
    }

    public void addln(String text) {
        this.add(text);
        this.newline();
    }

    private void newline() {
        this._buffer.append("\n");
        this._atNewLine = true;
    }

    public void begin() {
        if (!this._atNewLine) {
            this.newline();
        }
        this.indent();
        this._buffer.append("{");
        this.newline();
        ++this._nestingDepth;
    }

    public void end() {
        if (!this._atNewLine) {
            this.newline();
        }
        --this._nestingDepth;
        this.indent();
        this._buffer.append("}");
        this.newline();
    }

    private void indent() {
        if (this._atNewLine) {
            for (int i = 0; i < this._nestingDepth; ++i) {
                this._buffer.append(INDENT);
            }
            this._atNewLine = false;
        }
    }

    public String toString() {
        return this._buffer.toString();
    }
}

