/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.service.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.MethodFab;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.service.impl.AbstractFab;
import org.apache.hivemind.service.impl.CtClassSource;
import org.apache.hivemind.service.impl.MethodFabImpl;
import org.apache.hivemind.service.impl.ServiceMessages;

public class ClassFabImpl
extends AbstractFab
implements ClassFab {
    private Map _methods = new HashMap();
    private List _constructors = new ArrayList();

    public ClassFabImpl(CtClassSource source, CtClass ctClass) {
        super(source, ctClass);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ClassFab[\n");
        try {
            this.buildClassAndInheritance(buffer);
            this.buildFields(buffer);
            this.buildConstructors(buffer);
            this.buildMethods(buffer);
        }
        catch (Exception ex) {
            buffer.append(" *** ");
            buffer.append(ex);
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    private void buildMethods(StringBuffer buffer) {
        Iterator i = this._methods.values().iterator();
        while (i.hasNext()) {
            MethodFab mf = (MethodFab)i.next();
            buffer.append("\n");
            buffer.append(mf);
            buffer.append("\n");
        }
    }

    private void buildConstructors(StringBuffer buffer) {
        Iterator i = this._constructors.iterator();
        while (i.hasNext()) {
            buffer.append("\n");
            buffer.append(i.next());
        }
    }

    private void buildFields(StringBuffer buffer) throws NotFoundException {
        CtField[] fields = this.getCtClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            buffer.append("\n");
            buffer.append(this.modifiers(fields[i].getModifiers()));
            buffer.append(" ");
            buffer.append(fields[i].getType().getName());
            buffer.append(" ");
            buffer.append(fields[i].getName());
            buffer.append(";\n");
        }
    }

    private void buildClassAndInheritance(StringBuffer buffer) throws NotFoundException {
        buffer.append(this.modifiers(this.getCtClass().getModifiers()));
        buffer.append(" class ");
        buffer.append(this.getCtClass().getName());
        buffer.append(" extends ");
        buffer.append(this.getCtClass().getSuperclass().getName());
        buffer.append("\n");
        CtClass[] interfaces = this.getCtClass().getInterfaces();
        if (interfaces.length > 0) {
            buffer.append("  implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(interfaces[i].getName());
            }
            buffer.append("\n");
        }
    }

    private String modifiers(int modifiers) {
        return Modifier.toString(modifiers);
    }

    String getName() {
        return this.getCtClass().getName();
    }

    public void addField(String name, Class type) {
        CtClass ctType = this.convertClass(type);
        try {
            CtField field = new CtField(ctType, name, this.getCtClass());
            field.setModifiers(2);
            this.getCtClass().addField(field);
        }
        catch (CannotCompileException ex) {
            throw new ApplicationRuntimeException(ServiceMessages.unableToAddField(name, this.getCtClass(), ex), ex);
        }
    }

    public boolean containsMethod(MethodSignature ms) {
        return this._methods.get(ms) != null;
    }

    public MethodFab addMethod(int modifiers, MethodSignature ms, String body) {
        if (this._methods.get(ms) != null) {
            throw new ApplicationRuntimeException(ServiceMessages.duplicateMethodInClass(ms, this));
        }
        CtClass ctReturnType = this.convertClass(ms.getReturnType());
        CtClass[] ctParameters = this.convertClasses(ms.getParameterTypes());
        CtClass[] ctExceptions = this.convertClasses(ms.getExceptionTypes());
        CtMethod method = new CtMethod(ctReturnType, ms.getName(), ctParameters, this.getCtClass());
        try {
            method.setModifiers(modifiers);
            method.setBody(body);
            method.setExceptionTypes(ctExceptions);
            this.getCtClass().addMethod(method);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceMessages.unableToAddMethod(ms, this.getCtClass(), ex), ex);
        }
        MethodFabImpl result = new MethodFabImpl(this.getSource(), ms, method, body);
        this._methods.put(ms, result);
        return result;
    }

    public MethodFab getMethodFab(MethodSignature ms) {
        return (MethodFab)this._methods.get(ms);
    }

    public void addConstructor(Class[] parameterTypes, Class[] exceptions, String body) {
        CtClass[] ctParameters = this.convertClasses(parameterTypes);
        CtClass[] ctExceptions = this.convertClasses(exceptions);
        try {
            CtConstructor constructor = new CtConstructor(ctParameters, this.getCtClass());
            constructor.setExceptionTypes(ctExceptions);
            constructor.setBody(body);
            this.getCtClass().addConstructor(constructor);
            this._constructors.add(new AddedConstructor(parameterTypes, exceptions, body));
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceMessages.unableToAddConstructor(this.getCtClass(), ex), ex);
        }
    }

    private class AddedConstructor {
        private Class[] _parameterTypes;
        private Class[] _exceptionTypes;
        private String _body;

        AddedConstructor(Class[] parameterTypes, Class[] exceptionTypes, String body) {
            this._parameterTypes = parameterTypes;
            this._exceptionTypes = exceptionTypes;
            this._body = body;
        }

        public String toString() {
            int i;
            StringBuffer buffer = new StringBuffer();
            buffer.append("public ");
            buffer.append(ClassFabImpl.this.getCtClass().getName());
            buffer.append("(");
            int count = this.size(this._parameterTypes);
            for (i = 0; i < count; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this._parameterTypes[i].getName());
                buffer.append(" $");
                buffer.append(i + 1);
            }
            buffer.append(")");
            count = this.size(this._exceptionTypes);
            for (i = 0; i < count; ++i) {
                if (i == 0) {
                    buffer.append("\n  throws ");
                } else {
                    buffer.append(", ");
                }
                buffer.append(this._exceptionTypes[i].getName());
            }
            buffer.append("\n");
            buffer.append(this._body);
            buffer.append("\n");
            return buffer.toString();
        }

        private int size(Object[] array) {
            return array == null ? 0 : array.length;
        }
    }
}

