/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.goldfish.example.hsqldb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import jp.sourceforge.goldfish.example.hsqldb.HSQLDBServletContextListenerRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.Server;

public class HSQLDBServletContextListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog((Class)HSQLDBServletContextListener.class);

    public void contextInitialized(ServletContextEvent contextEvent) throws HSQLDBServletContextListenerRuntimeException {
        log.info((Object)"contextInitialized started.");
        try {
            ServletContext context = contextEvent.getServletContext();
            String dbpath = context.getInitParameter("dbpath");
            log.debug((Object)("getRealPath = " + context.getRealPath(dbpath)));
            String dbname = context.getInitParameter("dbname");
            log.debug((Object)("dbname = " + dbname));
            String dbport = context.getInitParameter("dbport");
            log.debug((Object)("dbport = " + dbport));
            String[] params = new String[]{"-database", context.getRealPath(dbpath) + "/" + dbname, "-port", dbport, "-nosystem_exit", "true"};
            Server.main((String[])params);
            log.info((Object)"contextInitialized executed.");
        }
        catch (Throwable e) {
            log.error((Object)"can't start HSQLDB Server.");
            log.error((Object)e.getMessage(), e);
            throw new HSQLDBServletContextListenerRuntimeException(e.getMessage(), e);
        }
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        log.info((Object)"contextDestroyed started.");
        Connection con = null;
        Statement stmt = null;
        try {
            ServletContext context = contextEvent.getServletContext();
            String driver = context.getInitParameter("driver");
            log.debug((Object)("driver = " + driver));
            String userid = context.getInitParameter("userid");
            log.debug((Object)("userid = " + userid));
            String password = context.getInitParameter("password");
            log.debug((Object)("password = " + password));
            String url = context.getInitParameter("url");
            log.debug((Object)("url = " + url));
            Class.forName(driver);
            con = DriverManager.getConnection(url, userid, password);
            stmt = con.createStatement();
            stmt.executeUpdate("SHUTDOWN");
            log.info((Object)"contextDestroyed executed.");
        }
        catch (SQLException e) {
            log.error((Object)"can't SHUTSOWN HSQLDB Server.");
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HSQLDBServletContextListenerRuntimeException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"can't SHUTSOWN HSQLDB Server.");
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HSQLDBServletContextListenerRuntimeException(e.getMessage(), e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    log.info((Object)"SQL Statement closed.");
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                    log.info((Object)"SQL connectin closed.");
                }
                catch (SQLException e) {}
            }
        }
    }
}

