/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.palette.PaletteOption;

public class PaletteColumn
implements IRender {
    private String _name;
    private String _clientId;
    private int _rows;
    private List _options = new ArrayList();

    public PaletteColumn(String name, String clientId, int rows) {
        this._name = name;
        this._clientId = clientId;
        this._rows = rows;
    }

    public void addOption(PaletteOption option) {
        this._options.add(option);
    }

    public void sortByValue() {
        Collections.sort(this._options, new ValueComparator());
    }

    public void sortByLabel() {
        Collections.sort(this._options, new LabelComparator());
    }

    public void render(IMarkupWriter writer, IRequestCycle cycle) {
        writer.begin("select");
        writer.attribute("multiple", "multiple");
        writer.attribute("name", this._name);
        if (this._clientId != null) {
            writer.attribute("id", this._clientId);
        }
        writer.attribute("size", this._rows);
        writer.println();
        int count = this._options.size();
        for (int i = 0; i < count; ++i) {
            PaletteOption o = (PaletteOption)this._options.get(i);
            o.render(writer, cycle);
        }
        writer.end();
    }

    private static class LabelComparator
    implements Comparator {
        private LabelComparator() {
        }

        public int compare(Object o1, Object o2) {
            PaletteOption option1 = (PaletteOption)o1;
            PaletteOption option2 = (PaletteOption)o2;
            return option1.getLabel().compareTo(option2.getLabel());
        }
    }

    private static class ValueComparator
    implements Comparator {
        private ValueComparator() {
        }

        public int compare(Object o1, Object o2) {
            PaletteOption option1 = (PaletteOption)o1;
            PaletteOption option2 = (PaletteOption)o2;
            return option1.getValue().compareTo(option2.getValue());
        }
    }
}

