/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.scope;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapTransactionManager;
import com.ibatis.sqlmap.engine.scope.BaseScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionState;

public class SessionScope
extends BaseScope {
    private static long nextId;
    private long id;
    private SqlMapClient sqlMapClient;
    private SqlMapExecutor sqlMapExecutor;
    private SqlMapTransactionManager sqlMapTxMgr;
    private int requestStackDepth;
    private Transaction transaction;
    private TransactionState transactionState;
    private TransactionState savedTransactionState;
    private boolean inBatch;
    private Object batch;
    private boolean commitRequired;

    public SessionScope() {
        this.reset();
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapExecutor getSqlMapExecutor() {
        return this.sqlMapExecutor;
    }

    public void setSqlMapExecutor(SqlMapExecutor sqlMapExecutor) {
        this.sqlMapExecutor = sqlMapExecutor;
    }

    public SqlMapTransactionManager getSqlMapTxMgr() {
        return this.sqlMapTxMgr;
    }

    public void setSqlMapTxMgr(SqlMapTransactionManager sqlMapTxMgr) {
        this.sqlMapTxMgr = sqlMapTxMgr;
    }

    public boolean isInBatch() {
        return this.inBatch;
    }

    public void setInBatch(boolean inBatch) {
        this.inBatch = inBatch;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }

    public Object getBatch() {
        return this.batch;
    }

    public void setBatch(Object batch) {
        this.batch = batch;
    }

    public int getRequestStackDepth() {
        return this.requestStackDepth;
    }

    public void incrementRequestStackDepth() {
        ++this.requestStackDepth;
    }

    public void decrementRequestStackDepth() {
        --this.requestStackDepth;
    }

    public boolean isCommitRequired() {
        return this.commitRequired;
    }

    public void setCommitRequired(boolean commitRequired) {
        this.commitRequired = commitRequired;
    }

    public void reset() {
        super.reset();
        this.batch = null;
        this.sqlMapExecutor = null;
        this.sqlMapTxMgr = null;
        this.inBatch = false;
        this.transaction = null;
        this.transactionState = null;
        this.batch = null;
        this.requestStackDepth = 0;
        this.id = SessionScope.getNextId();
    }

    public boolean equals(Object parameterObject) {
        if (this == parameterObject) {
            return true;
        }
        if (!(parameterObject instanceof SessionScope)) {
            return false;
        }
        SessionScope sessionScope = (SessionScope)parameterObject;
        return this.id == sessionScope.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public static synchronized long getNextId() {
        return nextId++;
    }

    public void saveTransactionState() {
        this.savedTransactionState = this.transactionState;
    }

    public void recallTransactionState() {
        this.transactionState = this.savedTransactionState;
    }
}

