/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.ModuleDescriptorProvider;
import org.apache.hivemind.Registry;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.impl.RegistryBuilder;
import org.apache.hivemind.impl.StrictErrorHandler;
import org.apache.hivemind.impl.XmlModuleDescriptorProvider;
import org.apache.hivemind.util.ContextResource;
import org.apache.tapestry.TapestryMessages;
import org.apache.tapestry.services.ApplicationInitializer;
import org.apache.tapestry.services.ServletRequestServicer;
import org.apache.tapestry.util.exception.ExceptionAnalyzer;

public class ApplicationServlet
extends HttpServlet {
    private static final long serialVersionUID = -8046042689991538059L;
    private static final String REGISTRY_KEY_PREFIX = "org.apache.tapestry.Registry:";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$ApplicationServlet == null ? (class$org$apache$tapestry$ApplicationServlet = ApplicationServlet.class$("org.apache.tapestry.ApplicationServlet")) : class$org$apache$tapestry$ApplicationServlet));
    private ClassResolver _resolver;
    private String _registryKey;
    private Registry _registry;
    private ServletRequestServicer _requestServicer;
    static /* synthetic */ Class class$org$apache$tapestry$ApplicationServlet;
    static /* synthetic */ Class class$org$apache$tapestry$services$ApplicationInitializer;
    static /* synthetic */ Class class$org$apache$tapestry$services$ServletRequestServicer;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doService(request, response);
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this._registry.setupThread();
            this._requestServicer.service(request, response);
        }
        catch (ServletException ex) {
            this.log("ServletException", ex);
            this.show((Exception)((Object)ex));
            throw ex;
        }
        catch (IOException ex) {
            this.log("IOException", ex);
            this.show(ex);
            throw ex;
        }
        finally {
            this._registry.cleanupThread();
        }
    }

    protected void show(Exception ex) {
        System.err.println("\n\n**********************************************************\n\n");
        new ExceptionAnalyzer().reportException(ex, System.err);
        System.err.println("\n**********************************************************\n");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doService(request, response);
    }

    public void init(ServletConfig config) throws ServletException {
        String name = config.getServletName();
        this._registryKey = REGISTRY_KEY_PREFIX + name;
        long startTime = System.currentTimeMillis();
        long elapsedToRegistry = 0L;
        super.init(config);
        this._resolver = this.createClassResolver();
        try {
            this._registry = this.constructRegistry(config);
            elapsedToRegistry = System.currentTimeMillis() - startTime;
            this.initializeApplication();
            config.getServletContext().setAttribute(this._registryKey, (Object)this._registry);
        }
        catch (Exception ex) {
            this.show(ex);
            throw new ServletException(TapestryMessages.servletInitFailure(ex), (Throwable)ex);
        }
        long elapsedOverall = System.currentTimeMillis() - startTime;
        LOG.info((Object)TapestryMessages.servletInit(name, elapsedToRegistry, elapsedOverall));
    }

    protected ClassResolver createClassResolver() {
        return new DefaultClassResolver();
    }

    protected Registry constructRegistry(ServletConfig config) {
        ErrorHandler errorHandler = this.constructErrorHandler(config);
        RegistryBuilder builder = new RegistryBuilder(errorHandler);
        builder.addModuleDescriptorProvider((ModuleDescriptorProvider)new XmlModuleDescriptorProvider(this._resolver));
        String name = config.getServletName();
        ServletContext context = config.getServletContext();
        this.addModuleIfExists(builder, context, "/WEB-INF/" + name + "/hivemodule.xml");
        this.addModuleIfExists(builder, context, "/WEB-INF/hivemodule.xml");
        return builder.constructRegistry(Locale.getDefault());
    }

    protected ErrorHandler constructErrorHandler(ServletConfig config) {
        return new StrictErrorHandler();
    }

    protected void addModuleIfExists(RegistryBuilder builder, ServletContext context, String path) {
        ContextResource r = new ContextResource(context, path);
        if (r.getResourceURL() == null) {
            return;
        }
        builder.addModuleDescriptorProvider((ModuleDescriptorProvider)new XmlModuleDescriptorProvider(this._resolver, (Resource)r));
    }

    protected void initializeApplication() {
        ApplicationInitializer ai = (ApplicationInitializer)this._registry.getService("tapestry.init.MasterInitializer", class$org$apache$tapestry$services$ApplicationInitializer == null ? (class$org$apache$tapestry$services$ApplicationInitializer = ApplicationServlet.class$("org.apache.tapestry.services.ApplicationInitializer")) : class$org$apache$tapestry$services$ApplicationInitializer);
        ai.initialize(this);
        this._registry.cleanupThread();
        this._requestServicer = (ServletRequestServicer)this._registry.getService("tapestry.request.ServletRequestServicer", class$org$apache$tapestry$services$ServletRequestServicer == null ? (class$org$apache$tapestry$services$ServletRequestServicer = ApplicationServlet.class$("org.apache.tapestry.services.ServletRequestServicer")) : class$org$apache$tapestry$services$ServletRequestServicer);
    }

    public void destroy() {
        this.getServletContext().removeAttribute(this._registryKey);
        if (this._registry != null) {
            this._registry.shutdown();
            this._registry = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

