/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.callback;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.callback.CallbackMessages;
import org.apache.tapestry.callback.ICallback;

public class ExternalCallback
implements ICallback {
    private static final long serialVersionUID = -6783421589702643930L;
    private String _pageName;
    private Object[] _parameters;

    public ExternalCallback(String pageName, Object[] parameters) {
        Defense.notNull((Object)pageName, (String)"pageName");
        this._pageName = pageName;
        this._parameters = parameters;
    }

    public ExternalCallback(IExternalPage page, Object[] parameters) {
        Defense.notNull((Object)page, (String)"page");
        this._pageName = page.getPageName();
        this._parameters = parameters;
    }

    public void performCallback(IRequestCycle cycle) {
        Defense.notNull((Object)cycle, (String)"cycle");
        try {
            IExternalPage page = (IExternalPage)cycle.getPage(this._pageName);
            cycle.activate(page);
            page.activateExternalPage(this._parameters, cycle);
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(CallbackMessages.pageNotExternal(this._pageName), (Throwable)ex);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ExternalCallback[");
        buffer.append(this._pageName);
        if (this._parameters != null) {
            for (int i = 0; i < this._parameters.length; ++i) {
                if (i == 0) {
                    buffer.append('/');
                } else {
                    buffer.append(", ");
                }
                buffer.append(this._parameters[i]);
            }
        }
        buffer.append(']');
        return buffer.toString();
    }
}

