/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine.encoders;

import org.apache.tapestry.engine.ServiceEncoder;
import org.apache.tapestry.engine.ServiceEncoding;

public class PageServiceEncoder
implements ServiceEncoder {
    private String _extension;
    private String _serviceName;

    public void encode(ServiceEncoding encoding) {
        String service = encoding.getParameterValue("service");
        if (!service.equals(this._serviceName)) {
            return;
        }
        String pageName = encoding.getParameterValue("page");
        if (pageName.indexOf(58) >= 0) {
            return;
        }
        StringBuffer buffer = new StringBuffer("/");
        buffer.append(pageName);
        buffer.append('.');
        buffer.append(this._extension);
        encoding.setServletPath(buffer.toString());
        encoding.setParameterValue("service", null);
        encoding.setParameterValue("page", null);
    }

    public void decode(ServiceEncoding encoding) {
        String servletPath = encoding.getServletPath();
        int dotx = servletPath.lastIndexOf(46);
        if (dotx < 0) {
            return;
        }
        String extension = servletPath.substring(dotx + 1);
        if (!extension.equals(this._extension)) {
            return;
        }
        String page = servletPath.substring(1, dotx);
        encoding.setParameterValue("service", this._serviceName);
        encoding.setParameterValue("page", page);
    }

    public void setExtension(String extension) {
        this._extension = extension;
    }

    public void setServiceName(String serviceName) {
        this._serviceName = serviceName;
    }
}

