/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.error;

import org.apache.commons.logging.Log;
import org.apache.tapestry.error.RequestExceptionReporter;
import org.apache.tapestry.util.exception.ExceptionAnalyzer;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebSession;

public class RequestExceptionReporterImpl
implements RequestExceptionReporter {
    private Log _log;
    private WebRequest _request;

    public void setLog(Log log) {
        this._log = log;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }

    public void reportRequestException(String message, Throwable cause) {
        this._log.warn((Object)message, cause);
        System.err.println("\n\n**********************************************************\n\n");
        System.err.println(message);
        System.err.println("\n");
        WebSession session = this._request.getSession(false);
        if (session != null) {
            System.err.println("      Session id    : " + session.getId());
        }
        System.err.println("\nExceptions:\n");
        new ExceptionAnalyzer().reportException(cause, System.err);
        System.err.println("\n**********************************************************\n");
    }
}

