/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.translator;

import java.util.Locale;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.AbstractFormComponentContributor;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.translator.Translator;
import org.apache.tapestry.valid.ValidatorException;

public abstract class AbstractTranslator
extends AbstractFormComponentContributor
implements Translator {
    private boolean _trim;
    private String _message;

    public AbstractTranslator() {
    }

    public AbstractTranslator(String initializer) {
        super(initializer);
    }

    public String format(IFormComponent field, Locale locale, Object object) {
        if (object == null) {
            return "";
        }
        return this.formatObject(field, locale, object);
    }

    public Object parse(IFormComponent field, ValidationMessages messages, String text) throws ValidatorException {
        String value = text == null ? null : (this._trim ? text.trim() : text);
        return HiveMind.isBlank((String)value) ? this.getValueForEmptyInput() : this.parseText(field, messages, value);
    }

    protected abstract String formatObject(IFormComponent var1, Locale var2, Object var3);

    protected abstract Object parseText(IFormComponent var1, ValidationMessages var2, String var3) throws ValidatorException;

    protected Object getValueForEmptyInput() {
        return null;
    }

    protected String buildMessage(ValidationMessages messages, IFormComponent field, String key) {
        String label = field.getDisplayName();
        Object[] parameters = this.getMessageParameters(messages.getLocale(), label);
        return messages.formatValidationMessage(this._message, key, parameters);
    }

    protected Object[] getMessageParameters(Locale locale, String label) {
        return new Object[]{label};
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        super.renderContribution(writer, cycle, context, field);
        if (this._trim) {
            context.addSubmitHandler("function (event) { Tapestry.trim_field_value('" + field.getClientId() + "'); }");
        }
    }

    public boolean isTrim() {
        return this._trim;
    }

    public void setTrim(boolean trim) {
        this._trim = trim;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }
}

