/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class Max
extends BaseValidator {
    private double _max;

    public Max() {
    }

    public Max(String initializer) {
        super(initializer);
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        Number value = (Number)object;
        if (value.doubleValue() > this._max) {
            throw new ValidatorException(this.buildMessage(messages, field), ValidationConstraint.TOO_LARGE);
        }
    }

    private String buildMessage(ValidationMessages messages, IFormComponent field) {
        return messages.formatValidationMessage(this.getMessage(), "number-too-large", new Object[]{field.getDisplayName(), new Double(this._max)});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        context.includeClasspathScript("/org/apache/tapestry/form/validator/NumberValidator.js");
        String message = TapestryUtils.enquote(this.buildMessage(context, field));
        StringBuffer buffer = new StringBuffer("function(event) { Tapestry.validate_max_number(event, '");
        buffer.append(field.getClientId());
        buffer.append("', ");
        buffer.append(this._max);
        buffer.append(", ");
        buffer.append(message);
        buffer.append("); }");
        context.addSubmitHandler(buffer.toString());
    }

    public void setMax(double max) {
        this._max = max;
    }
}

