/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

public class ObjectIdentityMap {
    private int _pairCount = 0;
    private Object[] _pairs;

    public void put(Object key, Object value) {
        for (int i = 0; i < this._pairCount; ++i) {
            int index = 2 * i;
            if (this._pairs[index] != key) continue;
            this._pairs[index + 1] = value;
            return;
        }
        this.expandPairsIfNeeded();
        int index = 2 * this._pairCount;
        this._pairs[index] = key;
        this._pairs[index + 1] = value;
        ++this._pairCount;
    }

    public Object get(Object key) {
        for (int i = 0; i < this._pairCount; ++i) {
            int index = 2 * i;
            if (this._pairs[index] != key) continue;
            return this._pairs[index + 1];
        }
        return null;
    }

    private void expandPairsIfNeeded() {
        int newLength = 2 * (this._pairCount + 1);
        int currentSize = this._pairs == null ? 0 : this._pairs.length;
        if (newLength >= currentSize) {
            int newSize = Math.max(10, 2 * currentSize);
            Object[] newPairsArray = new Object[newSize];
            if (currentSize > 0) {
                System.arraycopy(this._pairs, 0, newPairsArray, 0, currentSize);
            }
            this._pairs = newPairsArray;
        }
    }
}

