/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.tapestry.util.RegexpMatch;

public class RegexpMatcher {
    private PatternCompiler _patternCompiler;
    private PatternMatcher _matcher;
    private Map _compiledPatterns = new HashMap();
    private Map _escapedPatternStrings = new HashMap();

    protected Pattern compilePattern(String pattern) {
        if (this._patternCompiler == null) {
            this._patternCompiler = new Perl5Compiler();
        }
        try {
            return this._patternCompiler.compile(pattern, 32784);
        }
        catch (MalformedPatternException ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
    }

    protected Pattern getCompiledPattern(String pattern) {
        Pattern result = (Pattern)this._compiledPatterns.get(pattern);
        if (result == null) {
            result = this.compilePattern(pattern);
            this._compiledPatterns.put(pattern, result);
        }
        return result;
    }

    public void clear() {
        this._compiledPatterns.clear();
    }

    protected PatternMatcher getPatternMatcher() {
        if (this._matcher == null) {
            this._matcher = new Perl5Matcher();
        }
        return this._matcher;
    }

    public boolean matches(String pattern, String input) {
        Pattern compiledPattern = this.getCompiledPattern(pattern);
        return this.getPatternMatcher().matches(input, compiledPattern);
    }

    public boolean contains(String pattern, String input) {
        Pattern compiledPattern = this.getCompiledPattern(pattern);
        return this.getPatternMatcher().contains(input, compiledPattern);
    }

    public String getEscapedPatternString(String pattern) {
        String result = (String)this._escapedPatternStrings.get(pattern);
        if (result == null) {
            result = Perl5Compiler.quotemeta((String)pattern);
            this._escapedPatternStrings.put(pattern, result);
        }
        return result;
    }

    public RegexpMatch[] getMatches(String pattern, String input) {
        Pattern compiledPattern = this.getCompiledPattern(pattern);
        PatternMatcher matcher = this.getPatternMatcher();
        PatternMatcherInput matcherInput = new PatternMatcherInput(input);
        ArrayList<RegexpMatch> matches = new ArrayList<RegexpMatch>();
        while (matcher.contains(matcherInput, compiledPattern)) {
            MatchResult match = matcher.getMatch();
            matches.add(new RegexpMatch(match));
        }
        return matches.toArray(new RegexpMatch[matches.size()]);
    }

    public String[] getMatches(String pattern, String input, int subgroup) {
        Pattern compiledPattern = this.getCompiledPattern(pattern);
        PatternMatcher matcher = this.getPatternMatcher();
        PatternMatcherInput matcherInput = new PatternMatcherInput(input);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.contains(matcherInput, compiledPattern)) {
            MatchResult match = matcher.getMatch();
            String matchedInput = match.group(subgroup);
            matches.add(matchedInput);
        }
        return matches.toArray(new String[matches.size()]);
    }
}

