/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.tapestry.util.text.AsciiCharacterMatcher;
import org.apache.tapestry.util.text.CompoundMatcher;
import org.apache.tapestry.util.text.ExtendedReader;
import org.apache.tapestry.util.text.ICharacterMatcher;
import org.apache.tapestry.util.text.InverseMatcher;
import org.apache.tapestry.util.text.WhitespaceMatcher;

public class LocalizedPropertiesLoader {
    private static final String HEX_DIGITS = "0123456789ABCDEF";
    private static final ICharacterMatcher WHITESPACE = new WhitespaceMatcher(false);
    private static final ICharacterMatcher LINE_SEPARATOR = new AsciiCharacterMatcher("\n\r");
    private static final ICharacterMatcher NOT_LINE_SEPARATOR = new InverseMatcher(LINE_SEPARATOR);
    private static final ICharacterMatcher KEY_VALUE_SEPARATOR = new AsciiCharacterMatcher("=:");
    private static final ICharacterMatcher SEPARATOR = new AsciiCharacterMatcher("=:\r\n");
    private static final ICharacterMatcher COMMENT = new AsciiCharacterMatcher("#!");
    private static final ICharacterMatcher WHITESPACE_OR_SEPARATOR = new CompoundMatcher(new ICharacterMatcher[]{WHITESPACE, SEPARATOR});
    private ExtendedReader _extendedReader;

    public LocalizedPropertiesLoader(InputStream ins) {
        this(new InputStreamReader(ins));
    }

    public LocalizedPropertiesLoader(InputStream ins, String encoding) throws UnsupportedEncodingException {
        this(new InputStreamReader(ins, encoding));
    }

    public LocalizedPropertiesLoader(Reader reader) {
        this._extendedReader = new ExtendedReader(new BufferedReader(reader));
    }

    public void load(Map properties) throws IOException {
        while (!this.isAtEndOfStream()) {
            int nextChar = this._extendedReader.peek();
            if (COMMENT.matches((char)nextChar)) {
                this._extendedReader.skipCharacters(NOT_LINE_SEPARATOR);
                continue;
            }
            this._extendedReader.skipCharacters(WHITESPACE);
            if (!this.isAtEndOfLine()) {
                String key = this.readQuotedLine(WHITESPACE_OR_SEPARATOR);
                this._extendedReader.skipCharacters(WHITESPACE);
                nextChar = this._extendedReader.peek();
                if (nextChar > 0 && KEY_VALUE_SEPARATOR.matches((char)nextChar)) {
                    this._extendedReader.read();
                    this._extendedReader.skipCharacters(WHITESPACE);
                }
                String value = this.readQuotedLine(LINE_SEPARATOR);
                properties.put(key, value);
            }
            this._extendedReader.skipCharacters(LINE_SEPARATOR);
        }
    }

    private boolean isAtEndOfStream() throws IOException {
        int nextChar = this._extendedReader.peek();
        return nextChar < 0;
    }

    private boolean isAtEndOfLine() throws IOException {
        int nextChar = this._extendedReader.peek();
        if (nextChar < 0) {
            return true;
        }
        return LINE_SEPARATOR.matches((char)nextChar);
    }

    private String readQuotedLine(ICharacterMatcher terminators) throws IOException {
        int nextChar;
        StringBuffer buf = new StringBuffer();
        while ((nextChar = this._extendedReader.peek()) >= 0 && !terminators.matches((char)nextChar)) {
            try {
                char ch = this.readQuotedChar();
                buf.append(ch);
            }
            catch (IgnoreCharacterException e) {}
        }
        return buf.toString();
    }

    private char readQuotedChar() throws IOException, IgnoreCharacterException {
        int nextChar = this._extendedReader.read();
        if (nextChar < 0) {
            throw new IgnoreCharacterException();
        }
        char ch = (char)nextChar;
        if (ch != '\\') {
            return ch;
        }
        nextChar = this._extendedReader.read();
        if (nextChar < 0) {
            throw new IgnoreCharacterException();
        }
        ch = (char)nextChar;
        switch (ch) {
            case 'u': {
                char res = '\u0000';
                for (int i = 0; i < 4; ++i) {
                    nextChar = this._extendedReader.read();
                    if (nextChar < 0) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    char digitChar = (char)nextChar;
                    int digit = HEX_DIGITS.indexOf(Character.toUpperCase(digitChar));
                    if (digit < 0) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    res = (char)(res * 16 + digit);
                }
                return res;
            }
            case '\r': {
                nextChar = this._extendedReader.peek();
                if (nextChar == 10) {
                    this._extendedReader.read();
                }
            }
            case '\n': {
                this._extendedReader.skipCharacters(WHITESPACE);
                throw new IgnoreCharacterException();
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
        }
        return ch;
    }

    private static class IgnoreCharacterException
    extends Exception {
        private static final long serialVersionUID = 8366308710256427596L;

        private IgnoreCharacterException() {
        }
    }
}

