/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.cfg.NamingStrategy;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;

public class LocalSessionFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static ThreadLocal configTimeDataSourceHolder = new ThreadLocal();
    private static ThreadLocal configTimeTransactionManagerHolder = new ThreadLocal();
    private static ThreadLocal configTimeLobHandlerHolder = new ThreadLocal();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Resource[] mappingLocations;
    private Resource[] mappingJarLocations;
    private Resource[] mappingDirectoryLocations;
    private Properties hibernateProperties;
    private DataSource dataSource;
    private boolean useTransactionAwareDataSource = false;
    private TransactionManager jtaTransactionManager;
    private LobHandler lobHandler;
    private Interceptor entityInterceptor;
    private NamingStrategy namingStrategy;
    private boolean schemaUpdate = false;
    private Configuration configuration;
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$org$springframework$orm$hibernate$TransactionAwareDataSourceConnectionProvider;
    static /* synthetic */ Class class$org$springframework$orm$hibernate$LocalDataSourceConnectionProvider;
    static /* synthetic */ Class class$org$springframework$orm$hibernate$LocalTransactionManagerLookup;
    static /* synthetic */ Class class$net$sf$hibernate$SessionFactory;

    public static DataSource getConfigTimeDataSource() {
        return (DataSource)configTimeDataSourceHolder.get();
    }

    public static TransactionManager getConfigTimeTransactionManager() {
        return (TransactionManager)configTimeTransactionManagerHolder.get();
    }

    public static LobHandler getConfigTimeLobHandler() {
        return (LobHandler)configTimeLobHandlerHolder.get();
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setMappingResources(String[] mappingResources) {
        this.mappingLocations = new Resource[mappingResources.length];
        for (int i = 0; i < mappingResources.length; ++i) {
            this.mappingLocations[i] = new ClassPathResource(mappingResources[i].trim());
        }
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void setMappingJarLocations(Resource[] mappingJarLocations) {
        this.mappingJarLocations = mappingJarLocations;
    }

    public void setMappingDirectoryLocations(Resource[] mappingDirectoryLocations) {
        this.mappingDirectoryLocations = mappingDirectoryLocations;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public Properties getHibernateProperties() {
        if (this.hibernateProperties == null) {
            this.hibernateProperties = new Properties();
        }
        return this.hibernateProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUseTransactionAwareDataSource(boolean useTransactionAwareDataSource) {
        this.useTransactionAwareDataSource = useTransactionAwareDataSource;
    }

    public void setJtaTransactionManager(TransactionManager jtaTransactionManager) {
        this.jtaTransactionManager = jtaTransactionManager;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setSchemaUpdate(boolean schemaUpdate) {
        this.schemaUpdate = schemaUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws IllegalArgumentException, HibernateException, IOException {
        Configuration config = this.newConfiguration();
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        if (this.jtaTransactionManager != null) {
            configTimeTransactionManagerHolder.set(this.jtaTransactionManager);
        }
        if (this.lobHandler != null) {
            configTimeLobHandlerHolder.set(this.lobHandler);
        }
        try {
            int i;
            if (this.entityInterceptor != null) {
                config.setInterceptor(this.entityInterceptor);
            }
            if (this.namingStrategy != null) {
                config.setNamingStrategy(this.namingStrategy);
            }
            if (this.configLocation != null) {
                config.configure(this.configLocation.getURL());
            }
            if (this.hibernateProperties != null) {
                config.addProperties(this.hibernateProperties);
            }
            if (this.dataSource != null) {
                config.setProperty("hibernate.connection.provider_class", this.useTransactionAwareDataSource ? (class$org$springframework$orm$hibernate$TransactionAwareDataSourceConnectionProvider == null ? (class$org$springframework$orm$hibernate$TransactionAwareDataSourceConnectionProvider = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate.TransactionAwareDataSourceConnectionProvider")) : class$org$springframework$orm$hibernate$TransactionAwareDataSourceConnectionProvider).getName() : (class$org$springframework$orm$hibernate$LocalDataSourceConnectionProvider == null ? (class$org$springframework$orm$hibernate$LocalDataSourceConnectionProvider = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate.LocalDataSourceConnectionProvider")) : class$org$springframework$orm$hibernate$LocalDataSourceConnectionProvider).getName());
            }
            if (this.jtaTransactionManager != null) {
                config.setProperty("hibernate.transaction.manager_lookup_class", (class$org$springframework$orm$hibernate$LocalTransactionManagerLookup == null ? (class$org$springframework$orm$hibernate$LocalTransactionManagerLookup = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate.LocalTransactionManagerLookup")) : class$org$springframework$orm$hibernate$LocalTransactionManagerLookup).getName());
            }
            if (this.mappingLocations != null) {
                for (i = 0; i < this.mappingLocations.length; ++i) {
                    config.addInputStream(this.mappingLocations[i].getInputStream());
                }
            }
            if (this.mappingJarLocations != null) {
                for (i = 0; i < this.mappingJarLocations.length; ++i) {
                    Resource resource = this.mappingJarLocations[i];
                    config.addJar(resource.getFile());
                }
            }
            if (this.mappingDirectoryLocations != null) {
                for (i = 0; i < this.mappingDirectoryLocations.length; ++i) {
                    File file = this.mappingDirectoryLocations[i].getFile();
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("Mapping directory location [" + this.mappingDirectoryLocations[i] + "] does not denote a directory");
                    }
                    config.addDirectory(file);
                }
            }
            this.postProcessConfiguration(config);
            this.logger.info((Object)"Building new Hibernate SessionFactory");
            this.configuration = config;
            this.sessionFactory = this.newSessionFactory(config);
        }
        finally {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
            if (this.jtaTransactionManager != null) {
                configTimeTransactionManagerHolder.set(null);
            }
            if (this.lobHandler != null) {
                configTimeLobHandlerHolder.set(null);
            }
        }
        if (this.schemaUpdate) {
            this.updateDatabaseSchema();
        }
    }

    protected Configuration newConfiguration() throws HibernateException {
        return new Configuration();
    }

    protected void postProcessConfiguration(Configuration config) throws HibernateException {
    }

    protected SessionFactory newSessionFactory(Configuration config) throws HibernateException {
        return config.buildSessionFactory();
    }

    public void dropDatabaseSchema() throws DataAccessException {
        this.logger.info((Object)"Dropping database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory);
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)LocalSessionFactoryBean.this.configuration.getProperties());
                String[] sql = LocalSessionFactoryBean.this.configuration.generateDropSchemaScript(dialect);
                LocalSessionFactoryBean.this.executeSchemaScript(con, sql);
                return null;
            }
        });
    }

    public void createDatabaseSchema() throws DataAccessException {
        this.logger.info((Object)"Creating database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory);
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)LocalSessionFactoryBean.this.configuration.getProperties());
                String[] sql = LocalSessionFactoryBean.this.configuration.generateSchemaCreationScript(dialect);
                LocalSessionFactoryBean.this.executeSchemaScript(con, sql);
                return null;
            }
        });
    }

    public void updateDatabaseSchema() throws DataAccessException {
        this.logger.info((Object)"Updating database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory);
        hibernateTemplate.setFlushMode(0);
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)LocalSessionFactoryBean.this.configuration.getProperties());
                DatabaseMetadata metadata = new DatabaseMetadata(con, dialect);
                String[] sql = LocalSessionFactoryBean.this.configuration.generateSchemaUpdateScript(dialect, metadata);
                LocalSessionFactoryBean.this.executeSchemaScript(con, sql);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSchemaScript(Connection con, String[] sql) throws SQLException {
        if (sql != null && sql.length > 0) {
            boolean oldAutoCommit = con.getAutoCommit();
            if (!oldAutoCommit) {
                con.setAutoCommit(true);
            }
            try {
                Statement stmt = con.createStatement();
                try {
                    for (int i = 0; i < sql.length; ++i) {
                        this.executeSchemaStatement(stmt, sql[i]);
                    }
                }
                finally {
                    JdbcUtils.closeStatement(stmt);
                }
            }
            finally {
                if (!oldAutoCommit) {
                    con.setAutoCommit(false);
                }
            }
        }
    }

    protected void executeSchemaStatement(Statement stmt, String sql) throws SQLException {
        block3: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing schema statement: " + sql));
            }
            try {
                stmt.executeUpdate(sql);
            }
            catch (SQLException ex) {
                if (!this.logger.isWarnEnabled()) break block3;
                this.logger.warn((Object)("Unsuccessful schema statement: " + sql), (Throwable)ex);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Object getObject() {
        return this.sessionFactory;
    }

    public Class getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : (class$net$sf$hibernate$SessionFactory == null ? (class$net$sf$hibernate$SessionFactory = LocalSessionFactoryBean.class$("net.sf.hibernate.SessionFactory")) : class$net$sf$hibernate$SessionFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws HibernateException {
        this.logger.info((Object)"Closing Hibernate SessionFactory");
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        try {
            this.sessionFactory.close();
        }
        finally {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

