/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.impl.ErrorLogImpl;
import org.apache.hivemind.util.Defense;
import org.apache.hivemind.util.ToStringBuilder;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IMonitor;
import org.apache.tapestry.engine.IPageRecorder;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.engine.RequestCycleEnvironment;
import org.apache.tapestry.record.PageRecorderImpl;
import org.apache.tapestry.record.PropertyPersistenceStrategySource;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.services.AbsoluteURLBuilder;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.util.IdAllocator;
import org.apache.tapestry.util.QueryParameterMap;

public class RequestCycle
implements IRequestCycle {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$engine$RequestCycle == null ? (class$org$apache$tapestry$engine$RequestCycle = RequestCycle.class$("org.apache.tapestry.engine.RequestCycle")) : class$org$apache$tapestry$engine$RequestCycle));
    private IPage _page;
    private IEngine _engine;
    private String _serviceName;
    private IMonitor _monitor;
    private PropertyPersistenceStrategySource _strategySource;
    private IPageSource _pageSource;
    private Infrastructure _infrastructure;
    private QueryParameterMap _parameters;
    private AbsoluteURLBuilder _absoluteURLBuilder;
    private Map _loadedPages;
    private Map _pageRecorders;
    private boolean _rewinding = false;
    private Map _attributes = new HashMap();
    private int _actionId;
    private int _targetActionId;
    private IComponent _targetComponent;
    private Object[] _listenerParameters;
    private ErrorLog _log;
    private RequestContext _requestContext;
    private IdAllocator _idAllocator = new IdAllocator();
    static /* synthetic */ Class class$org$apache$tapestry$engine$RequestCycle;

    public RequestCycle(IEngine engine, QueryParameterMap parameters, String serviceName, IMonitor monitor, RequestCycleEnvironment environment, RequestContext context) {
        this._engine = engine;
        this._parameters = parameters;
        this._serviceName = serviceName;
        this._monitor = monitor;
        this._infrastructure = environment.getInfrastructure();
        this._pageSource = this._infrastructure.getPageSource();
        this._strategySource = environment.getStrategySource();
        this._absoluteURLBuilder = environment.getAbsoluteURLBuilder();
        this._requestContext = context;
        this._log = new ErrorLogImpl(environment.getErrorHandler(), LOG);
    }

    public RequestCycle() {
    }

    public void cleanup() {
        if (this._loadedPages == null) {
            return;
        }
        Iterator i = this._loadedPages.values().iterator();
        while (i.hasNext()) {
            IPage page = (IPage)i.next();
            this._pageSource.releasePage(page);
        }
        this._loadedPages = null;
        this._pageRecorders = null;
    }

    public IEngineService getService() {
        return this._infrastructure.getServiceMap().getService(this._serviceName);
    }

    public String encodeURL(String URL2) {
        return this._infrastructure.getResponse().encodeURL(URL2);
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public IMonitor getMonitor() {
        return this._monitor;
    }

    public String getNextActionId() {
        return Integer.toHexString(++this._actionId);
    }

    public IPage getPage() {
        return this._page;
    }

    public IPage getPage(String name) {
        Defense.notNull((Object)name, (String)"name");
        IPage result = null;
        if (this._loadedPages != null) {
            result = (IPage)this._loadedPages.get(name);
        }
        if (result == null) {
            result = this.loadPage(name);
            if (this._loadedPages == null) {
                this._loadedPages = new HashMap();
            }
            this._loadedPages.put(name, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPage loadPage(String name) {
        try {
            this._monitor.pageLoadBegin(name);
            IPage result = this._pageSource.getPage(this, name, this._monitor);
            IPageRecorder recorder = this.getPageRecorder(name);
            recorder.rollback(result);
            result.setChangeObserver(recorder);
            IPage iPage = result;
            return iPage;
        }
        finally {
            this._monitor.pageLoadEnd(name);
        }
    }

    protected IPageRecorder getPageRecorder(String name) {
        IPageRecorder result;
        if (this._pageRecorders == null) {
            this._pageRecorders = new HashMap();
        }
        if ((result = (IPageRecorder)this._pageRecorders.get(name)) == null) {
            result = new PageRecorderImpl(name, this, this._strategySource, this._log);
            this._pageRecorders.put(name, result);
        }
        return result;
    }

    public boolean isRewinding() {
        return this._rewinding;
    }

    public boolean isRewound(IComponent component) throws StaleLinkException {
        if (!this._rewinding) {
            return false;
        }
        if (this._actionId != this._targetActionId) {
            return false;
        }
        if (component == this._targetComponent) {
            return true;
        }
        throw new StaleLinkException(component, Integer.toHexString(this._targetActionId), this._targetComponent.getExtendedId());
    }

    public void removeAttribute(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing attribute " + name));
        }
        this._attributes.remove(name);
    }

    public void renderPage(IMarkupWriter writer) {
        String pageName = this._page.getPageName();
        this._monitor.pageRenderBegin(pageName);
        this._rewinding = false;
        this._actionId = -1;
        this._targetActionId = 0;
        try {
            this._page.renderPage(writer, this);
        }
        catch (ApplicationRuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), (Object)this._page, null, ex);
        }
        finally {
            this.reset();
        }
        this._monitor.pageRenderEnd(pageName);
    }

    private void reset() {
        this._actionId = 0;
        this._targetActionId = 0;
        this._attributes.clear();
        this._idAllocator.clear();
    }

    /*
     * Exception decompiling
     */
    public void rewindForm(IForm form) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void rewindPage(String targetActionId, IComponent targetComponent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setAttribute(String name, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set attribute " + name + " to " + value));
        }
        this._attributes.put(name, value);
    }

    public void commitPageChanges() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Committing page changes");
        }
        if (this._pageRecorders == null || this._pageRecorders.isEmpty()) {
            return;
        }
        Iterator i = this._pageRecorders.values().iterator();
        while (i.hasNext()) {
            IPageRecorder recorder = (IPageRecorder)i.next();
            recorder.commit();
        }
    }

    public void discardPage(String name) {
        this.forgetPage(name);
    }

    public Object[] getServiceParameters() {
        return this.getListenerParameters();
    }

    public void setServiceParameters(Object[] serviceParameters) {
        this.setListenerParameters(serviceParameters);
    }

    public Object[] getListenerParameters() {
        return this._listenerParameters;
    }

    public void setListenerParameters(Object[] parameters) {
        this._listenerParameters = parameters;
    }

    public void activate(String name) {
        IPage page = this.getPage(name);
        this.activate(page);
    }

    public void activate(IPage page) {
        Defense.notNull((Object)page, (String)"page");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activating page " + page));
        }
        Tapestry.clearMethodInvocations();
        page.validate(this);
        Tapestry.checkMethodInvocation("AbstractPage.validate()", "validate()", page);
        this._page = page;
    }

    public String getParameter(String name) {
        return this._parameters.getParameterValue(name);
    }

    public String[] getParameters(String name) {
        return this._parameters.getParameterValues(name);
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.append("rewinding", this._rewinding);
        b.append("serviceName", this._serviceName);
        b.append("serviceParameters", (Object)this._listenerParameters);
        if (this._loadedPages != null) {
            b.append("loadedPages", this._loadedPages.keySet());
        }
        b.append("attributes", (Object)this._attributes);
        b.append("targetActionId", this._targetActionId);
        b.append("targetComponent", (Object)this._targetComponent);
        return b.toString();
    }

    public String getAbsoluteURL(String partialURL) {
        String contextPath = this._infrastructure.getRequest().getContextPath();
        return this._absoluteURLBuilder.constructURL(contextPath + partialURL);
    }

    public void forgetPage(String pageName) {
        Defense.notNull((Object)pageName, (String)"pageName");
        this._strategySource.discardAllStoredChanged(pageName);
    }

    public Infrastructure getInfrastructure() {
        return this._infrastructure;
    }

    public RequestContext getRequestContext() {
        return this._requestContext;
    }

    public String getUniqueId(String baseId) {
        return this._idAllocator.allocateId(baseId);
    }

    public void sendRedirect(String URL2) {
        throw new RedirectException(URL2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

