/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine.encoders;

import org.apache.tapestry.engine.ServiceEncoder;
import org.apache.tapestry.engine.ServiceEncoding;

public class DirectServiceEncoder
implements ServiceEncoder {
    private String _statelessExtension;
    private String _statefulExtension;

    public void encode(ServiceEncoding encoding) {
        String service = encoding.getParameterValue("service");
        if (!service.equals("direct")) {
            return;
        }
        String pageName = encoding.getParameterValue("page");
        if (pageName.indexOf(58) >= 0) {
            return;
        }
        String stateful = encoding.getParameterValue("session");
        String componentIdPath = encoding.getParameterValue("component");
        StringBuffer buffer = new StringBuffer("/");
        buffer.append(pageName);
        buffer.append(",");
        buffer.append(componentIdPath);
        buffer.append(".");
        buffer.append(stateful != null ? this._statefulExtension : this._statelessExtension);
        encoding.setServletPath(buffer.toString());
        encoding.setParameterValue("service", null);
        encoding.setParameterValue("page", null);
        encoding.setParameterValue("session", null);
        encoding.setParameterValue("component", null);
    }

    public void decode(ServiceEncoding encoding) {
        String servletPath = encoding.getServletPath();
        int dotx = servletPath.lastIndexOf(46);
        if (dotx < 0) {
            return;
        }
        String extension = servletPath.substring(dotx + 1);
        if (!extension.equals(this._statefulExtension) && !extension.equals(this._statelessExtension)) {
            return;
        }
        int commax = servletPath.lastIndexOf(44);
        String pageName = servletPath.substring(1, commax);
        String componentIdPath = servletPath.substring(commax + 1, dotx);
        encoding.setParameterValue("service", "direct");
        encoding.setParameterValue("page", pageName);
        encoding.setParameterValue("session", extension.equals(this._statefulExtension) ? "T" : null);
        encoding.setParameterValue("component", componentIdPath);
    }

    public void setStatefulExtension(String statefulExtension) {
        this._statefulExtension = statefulExtension;
    }

    public void setStatelessExtension(String statelessExtension) {
        this._statelessExtension = statelessExtension;
    }
}

