/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine.state;

import org.apache.tapestry.SessionStoreOptimized;
import org.apache.tapestry.engine.state.StateObjectFactory;
import org.apache.tapestry.engine.state.StateObjectPersistenceManager;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebSession;

public class SessionScopeManager
implements StateObjectPersistenceManager {
    private WebRequest _request;
    private String _applicationId;

    private String buildKey(String objectName) {
        return "state:" + this._applicationId + ":" + objectName;
    }

    private WebSession getSession() {
        return this._request.getSession(true);
    }

    public boolean exists(String objectName) {
        WebSession session = this._request.getSession(false);
        if (session == null) {
            return false;
        }
        return session.getAttribute(this.buildKey(objectName)) != null;
    }

    public Object get(String objectName, StateObjectFactory factory) {
        String key = this.buildKey(objectName);
        WebSession session = this.getSession();
        Object result = session.getAttribute(key);
        if (result == null) {
            result = factory.createStateObject();
            session.setAttribute(key, result);
        }
        return result;
    }

    public void store(String objectName, Object stateObject) {
        SessionStoreOptimized optimized;
        if (stateObject instanceof SessionStoreOptimized && !(optimized = (SessionStoreOptimized)stateObject).isStoreToSessionNeeded()) {
            return;
        }
        String key = this.buildKey(objectName);
        WebSession session = this.getSession();
        session.setAttribute(key, stateObject);
    }

    public void setApplicationId(String applicationName) {
        this._applicationId = applicationName;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }
}

