/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.Iterator;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.spec.IAssetSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class InjectAssetWorker
implements EnhancementWorker {
    private ErrorLog _errorLog;
    static /* synthetic */ Class class$org$apache$tapestry$IAsset;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Iterator i = spec.getAssetNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            IAssetSpecification as = spec.getAsset(name);
            String propertyName = as.getPropertyName();
            if (propertyName == null) continue;
            try {
                this.injectAsset(op, name, propertyName, as.getLocation());
            }
            catch (Exception ex) {
                this._errorLog.error(EnhanceMessages.errorAddingProperty(propertyName, op.getBaseClass(), ex), as.getLocation(), (Throwable)ex);
            }
        }
    }

    public void injectAsset(EnhancementOperation op, String assetName, String propertyName, Location location) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)assetName, (String)"assetName");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Class propertyType = EnhanceUtils.extractPropertyType(op, propertyName, null);
        op.claimReadonlyProperty(propertyName);
        if (!propertyType.isAssignableFrom(class$org$apache$tapestry$IAsset == null ? (class$org$apache$tapestry$IAsset = InjectAssetWorker.class$("org.apache.tapestry.IAsset")) : class$org$apache$tapestry$IAsset)) {
            throw new ApplicationRuntimeException(EnhanceMessages.incompatiblePropertyType(propertyName, propertyType, class$org$apache$tapestry$IAsset == null ? (class$org$apache$tapestry$IAsset = InjectAssetWorker.class$("org.apache.tapestry.IAsset")) : class$org$apache$tapestry$IAsset));
        }
        String methodName = op.getAccessorMethodName(propertyName);
        MethodSignature sig = new MethodSignature(propertyType, methodName, null, null);
        String code = "return getAsset(\"" + assetName + "\");";
        op.addMethod(1, sig, code, location);
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

