/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.util.Locale;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessagesImpl;

public class FormComponentContributorContextImpl
extends ValidationMessagesImpl
implements FormComponentContributorContext {
    private final ClassResolver _resolver;
    private final PageRenderSupport _pageRenderSupport;
    private final IFormComponent _field;
    private final IForm _form;
    private final String _formId;

    FormComponentContributorContextImpl(IFormComponent field) {
        super(field, Locale.ENGLISH);
        this._field = field;
        this._resolver = null;
        this._formId = null;
        this._pageRenderSupport = null;
        this._form = null;
    }

    public FormComponentContributorContextImpl(Locale locale, IRequestCycle cycle, IFormComponent field) {
        super(field, locale);
        this._field = field;
        this._form = field.getForm();
        this._formId = this._form.getName();
        this._resolver = cycle.getInfrastructure().getClassResolver();
        this._pageRenderSupport = TapestryUtils.getPageRenderSupport(cycle, field);
    }

    public void includeClasspathScript(String path) {
        ClasspathResource resource = new ClasspathResource(this._resolver, path);
        this._pageRenderSupport.addExternalScript((Resource)resource);
    }

    public void addSubmitHandler(String submitListener) {
        this._pageRenderSupport.addInitializationScript("Tapestry.onsubmit('" + this._formId + "', " + submitListener + ");");
    }

    public void registerForFocus(int priority) {
        this._form.registerForFocus(this._field, priority);
    }
}

