/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import org.apache.tapestry.IMarkupWriter;

public abstract class InsertTextMode {
    public static final InsertTextMode BREAK = new BreakMode();
    public static final InsertTextMode PARAGRAPH = new ParagraphMode();
    private final String _name;

    protected InsertTextMode(String name) {
        this._name = name;
    }

    public String toString() {
        return "InsertTextMode[" + this._name + "]";
    }

    public abstract void writeLine(int var1, String var2, IMarkupWriter var3, boolean var4);

    private static class ParagraphMode
    extends InsertTextMode {
        private ParagraphMode() {
            super("PARAGRAPH");
        }

        public void writeLine(int lineNumber, String line, IMarkupWriter writer, boolean raw) {
            writer.begin("p");
            writer.print(line, raw);
            writer.end();
        }
    }

    private static class BreakMode
    extends InsertTextMode {
        private BreakMode() {
            super("BREAK");
        }

        public void writeLine(int lineNumber, String line, IMarkupWriter writer, boolean raw) {
            if (lineNumber > 0) {
                writer.beginEmpty("br");
            }
            writer.print(line, raw);
        }
    }
}

