/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.link;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.components.LinkEventType;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.link.DefaultLinkRenderer;
import org.apache.tapestry.link.ILinkRenderer;

public abstract class AbstractLinkComponent
extends AbstractComponent
implements ILinkComponent {
    private Map _eventHandlers;

    public abstract boolean isDisabled();

    public void addEventHandler(LinkEventType eventType, String functionName) {
        Object currentValue;
        if (this._eventHandlers == null) {
            this._eventHandlers = new HashMap();
        }
        if ((currentValue = this._eventHandlers.get(eventType)) == null) {
            this._eventHandlers.put(eventType, functionName);
            return;
        }
        if (currentValue instanceof String) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(currentValue);
            list.add(functionName);
            this._eventHandlers.put(eventType, list);
            return;
        }
        List list = (List)currentValue;
        list.add(functionName);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.getRenderer().renderLink(writer, cycle, this);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._eventHandlers = null;
        super.cleanupAfterRender(cycle);
    }

    protected void writeEventHandlers(IMarkupWriter writer, IRequestCycle cycle) {
        String name = null;
        if (this._eventHandlers == null) {
            return;
        }
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport(cycle, this);
        Iterator i = this._eventHandlers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            LinkEventType type = (LinkEventType)entry.getKey();
            name = this.writeEventHandler(writer, pageRenderSupport, name, type.getAttributeName(), entry.getValue());
        }
    }

    protected String writeEventHandler(IMarkupWriter writer, PageRenderSupport pageRenderSupport, String name, String attributeName, Object value) {
        String wrapperFunctionName;
        if (value instanceof String) {
            wrapperFunctionName = (String)value;
        } else {
            String finalName = name == null ? pageRenderSupport.getUniqueString("Link") : name;
            wrapperFunctionName = attributeName + "_" + finalName;
            StringBuffer buffer = new StringBuffer();
            buffer.append("function ");
            buffer.append(wrapperFunctionName);
            buffer.append(" ()\n{\n");
            Iterator i = ((List)value).iterator();
            while (i.hasNext()) {
                String functionName = (String)i.next();
                buffer.append("  ");
                buffer.append(functionName);
                buffer.append("();\n");
            }
            buffer.append("}\n\n");
            pageRenderSupport.addBodyScript(buffer.toString());
        }
        writer.attribute(attributeName, "javascript:" + wrapperFunctionName + "();");
        return name;
    }

    public abstract ILinkRenderer getRenderer();

    public abstract void setRenderer(ILinkRenderer var1);

    public void renderAdditionalAttributes(IMarkupWriter writer, IRequestCycle cycle) {
        this.writeEventHandlers(writer, cycle);
        this.renderInformalParameters(writer, cycle);
    }

    protected ILink getLink(IRequestCycle cycle, String serviceName, Object parameter) {
        IEngineService service = cycle.getEngine().getService(serviceName);
        return service.getLink(false, parameter);
    }

    public abstract String getAnchor();

    public ILink getLink(IRequestCycle cycle) {
        return null;
    }

    protected void finishLoad() {
        this.setRenderer(DefaultLinkRenderer.SHARED_INSTANCE);
    }

    public abstract /* synthetic */ String getTarget();

    public abstract /* synthetic */ String getScheme();
}

