/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.script;

import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.script.IScriptToken;
import org.apache.tapestry.script.InputSymbolToken;
import org.apache.tapestry.util.xml.BaseRule;
import org.apache.tapestry.util.xml.DocumentParseException;
import org.apache.tapestry.util.xml.RuleDirectedParser;
import org.xml.sax.Attributes;

class InputSymbolRule
extends BaseRule {
    private ClassResolver _resolver;

    public InputSymbolRule(ClassResolver resolver) {
        this._resolver = resolver;
    }

    public void startElement(RuleDirectedParser parser, Attributes attributes) {
        String key = this.getAttribute(attributes, "key");
        parser.validate(key, "^_?[a-zA-Z]\\w*$", "ScriptParser.invalid-key");
        String className = this.getAttribute(attributes, "class");
        Class expectedClass = this.lookupClass(parser, className);
        String required = this.getAttribute(attributes, "required");
        InputSymbolToken token = new InputSymbolToken(key, expectedClass, required.equals("yes"), parser.getLocation());
        IScriptToken parent = (IScriptToken)parser.peek();
        parent.addToken(token);
    }

    private Class lookupClass(RuleDirectedParser parser, String className) {
        if (HiveMind.isBlank((String)className)) {
            return null;
        }
        try {
            return this._resolver.findClass(className);
        }
        catch (Exception ex) {
            throw new DocumentParseException(Tapestry.format("ScriptParser.unable-to-resolve-class", className), parser.getLocation(), (Throwable)ex);
        }
    }
}

