/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.services.impl.EngineServiceOuterProxy;
import org.apache.tapestry.services.impl.EngineServiceSource;
import org.apache.tapestry.services.impl.ImplMessages;

public class EngineServiceInnerProxy
implements IEngineService,
Serializable {
    private static final long serialVersionUID = -8128030027597659447L;
    private final String _serviceName;
    private final EngineServiceOuterProxy _outerProxy;
    private final EngineServiceSource _source;

    public EngineServiceInnerProxy(String serviceName, EngineServiceOuterProxy outerProxy, EngineServiceSource source) {
        Defense.notNull((Object)serviceName, (String)"serviceName");
        Defense.notNull((Object)outerProxy, (String)"outerProxy");
        Defense.notNull((Object)source, (String)"source");
        this._serviceName = serviceName;
        this._outerProxy = outerProxy;
        this._source = source;
    }

    public String toString() {
        return ImplMessages.engineServiceInnerProxyToString(this._serviceName);
    }

    private IEngineService resolve() {
        IEngineService service = this._source.resolveEngineService(this._serviceName);
        this._outerProxy.installDelegate(service);
        return service;
    }

    public synchronized ILink getLink(boolean post, Object parameter) {
        return this.resolve().getLink(post, parameter);
    }

    public synchronized void service(IRequestCycle cycle) throws IOException {
        this.resolve().service(cycle);
    }

    public String getName() {
        return this._serviceName;
    }
}

