/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ToStringBuilder;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.spec.IExtensionSpecification;
import org.apache.tapestry.spec.ILibrarySpecification;
import org.apache.tapestry.spec.LocatablePropertyHolder;

public class LibrarySpecification
extends LocatablePropertyHolder
implements ILibrarySpecification {
    private Map _pages;
    private Map _components;
    private Map _libraries;
    private String _description;
    private Map _extensions;
    private Map _instantiatedExtensions;
    private String _publicId;
    private Resource _specificationLocation;

    public String getLibrarySpecificationPath(String id) {
        return (String)this.get(this._libraries, id);
    }

    public void setLibrarySpecificationPath(String id, String path) {
        if (this._libraries == null) {
            this._libraries = new HashMap();
        }
        if (this._libraries.containsKey(id)) {
            throw new IllegalArgumentException(Tapestry.format("LibrarySpecification.duplicate-child-namespace-id", id));
        }
        this._libraries.put(id, path);
    }

    public List getLibraryIds() {
        return this.sortedKeys(this._libraries);
    }

    public String getPageSpecificationPath(String name) {
        return (String)this.get(this._pages, name);
    }

    public void setPageSpecificationPath(String name, String path) {
        if (this._pages == null) {
            this._pages = new HashMap();
        }
        if (this._pages.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.format("LibrarySpecification.duplicate-page-name", name));
        }
        this._pages.put(name, path);
    }

    public List getPageNames() {
        return this.sortedKeys(this._pages);
    }

    public void setComponentSpecificationPath(String alias, String path) {
        if (this._components == null) {
            this._components = new HashMap();
        }
        if (this._components.containsKey(alias)) {
            throw new IllegalArgumentException(Tapestry.format("LibrarySpecification.duplicate-component-alias", alias));
        }
        this._components.put(alias, path);
    }

    public String getComponentSpecificationPath(String alias) {
        return (String)this.get(this._components, alias);
    }

    public List getComponentTypes() {
        return this.sortedKeys(this._components);
    }

    public String getServiceClassName(String name) {
        throw new UnsupportedOperationException();
    }

    public List getServiceNames() {
        return Collections.EMPTY_LIST;
    }

    public void setServiceClassName(String name, String className) {
        throw new UnsupportedOperationException();
    }

    private List sortedKeys(Map map) {
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(map.keySet());
        Collections.sort(result);
        return result;
    }

    private Object get(Map map, Object key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public Map getExtensionSpecifications() {
        if (this._extensions == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._extensions);
    }

    public void addExtensionSpecification(String name, IExtensionSpecification extension) {
        if (this._extensions == null) {
            this._extensions = new HashMap();
        }
        if (this._extensions.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.format("LibrarySpecification.duplicate-extension-name", this, name));
        }
        this._extensions.put(name, extension);
    }

    public synchronized List getExtensionNames() {
        return this.sortedKeys(this._instantiatedExtensions);
    }

    public IExtensionSpecification getExtensionSpecification(String name) {
        if (this._extensions == null) {
            return null;
        }
        return (IExtensionSpecification)this._extensions.get(name);
    }

    public boolean checkExtension(String name) {
        if (this._extensions == null) {
            return false;
        }
        return this._extensions.containsKey(name);
    }

    public synchronized Object getExtension(String name) {
        return this.getExtension(name, null);
    }

    public synchronized Object getExtension(String name, Class typeConstraint) {
        if (this._instantiatedExtensions == null) {
            this._instantiatedExtensions = new HashMap();
        }
        Object result = this._instantiatedExtensions.get(name);
        IExtensionSpecification spec = this.getExtensionSpecification(name);
        if (spec == null) {
            throw new IllegalArgumentException(Tapestry.format("LibrarySpecification.no-such-extension", name));
        }
        if (result == null) {
            result = spec.instantiateExtension();
            this._instantiatedExtensions.put(name, result);
        }
        if (typeConstraint != null) {
            this.applyTypeConstraint(name, result, typeConstraint, spec.getLocation());
        }
        return result;
    }

    protected void applyTypeConstraint(String name, Object extension, Class typeConstraint, Location location) {
        Class<?> extensionClass = extension.getClass();
        if (typeConstraint.isAssignableFrom(extensionClass)) {
            return;
        }
        String key = typeConstraint.isInterface() ? "LibrarySpecification.extension-does-not-implement-interface" : "LibrarySpecification.extension-not-a-subclass";
        throw new ApplicationRuntimeException(Tapestry.format(key, name, extensionClass.getName(), typeConstraint.getName()), location, null);
    }

    public synchronized void instantiateImmediateExtensions() {
        if (this._extensions == null) {
            return;
        }
        Iterator i = this._extensions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            IExtensionSpecification spec = (IExtensionSpecification)entry.getValue();
            if (!spec.isImmediate()) continue;
            String name = (String)entry.getKey();
            this.getExtension(name);
        }
    }

    protected Map getExtensions() {
        return this._extensions;
    }

    protected void setExtensions(Map extension) {
        this._extensions = extension;
    }

    protected Map getLibraries() {
        return this._libraries;
    }

    protected void setLibraries(Map libraries) {
        this._libraries = libraries;
    }

    protected Map getPages() {
        return this._pages;
    }

    protected void setPages(Map pages) {
        this._pages = pages;
    }

    protected Map getServices() {
        return Collections.EMPTY_MAP;
    }

    protected void setServices(Map services) {
    }

    protected Map getComponents() {
        return this._components;
    }

    protected void setComponents(Map components) {
        this._components = components;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public void setPublicId(String publicId) {
        this._publicId = publicId;
    }

    public Resource getSpecificationLocation() {
        return this._specificationLocation;
    }

    public void setSpecificationLocation(Resource specificationLocation) {
        this._specificationLocation = specificationLocation;
    }

    public synchronized String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("components", (Object)this._components);
        builder.append("description", this._description);
        builder.append("instantiatedExtensions", (Object)this._instantiatedExtensions);
        builder.append("libraries", (Object)this._libraries);
        builder.append("pages", (Object)this._pages);
        builder.append("publicId", this._publicId);
        builder.append("specificationLocation", (Object)this._specificationLocation);
        this.extendDescription(builder);
        return builder.toString();
    }

    protected void extendDescription(ToStringBuilder builder) {
    }
}

