/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.components.Block;
import org.apache.tapestry.contrib.palette.PaletteColumn;
import org.apache.tapestry.contrib.palette.PaletteOption;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidatorException;

public abstract class Palette
extends BaseComponent
implements ValidatableField {
    private static final int MAP_SIZE = 7;
    private Map _symbols;

    public abstract void setAvailableColumn(PaletteColumn var1);

    public abstract void setSelectedColumn(PaletteColumn var1);

    public abstract void setName(String var1);

    public abstract void setForm(IForm var1);

    public abstract void setRequiredMessage(String var1);

    public abstract String getIdParameter();

    public abstract void setClientId(String var1);

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = TapestryUtils.getForm((IRequestCycle)cycle, (IComponent)this);
        this.setForm(form);
        if (form.wasPrerendered(writer, (IComponent)this)) {
            return;
        }
        IValidationDelegate delegate = form.getDelegate();
        delegate.setFormComponent((IFormComponent)this);
        form.getElementId((IFormComponent)this);
        if (form.isRewinding()) {
            if (!this.isDisabled()) {
                this.rewindFormComponent(writer, cycle);
            }
        } else if (!cycle.isRewinding()) {
            if (!this.isDisabled()) {
                delegate.registerForFocus((IFormComponent)this, 1);
            }
            this.renderFormComponent(writer, cycle);
            if (delegate.isInError()) {
                delegate.registerForFocus((IFormComponent)this, 3);
            }
        }
        super.renderComponent(writer, cycle);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String clientId = cycle.getUniqueId(TapestryUtils.convertTapestryIdToNMToken((String)this.getIdParameter()));
        this.setClientId(clientId);
        this._symbols = new HashMap(7);
        this.runScript(cycle);
        this.constructColumns();
        this.getValidatableFieldSupport().renderContributions((ValidatableField)this, writer, cycle);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Object[] values = cycle.getParameters(this.getName());
        int count = Tapestry.size((Object[])values);
        ArrayList<Object> selected = new ArrayList<Object>(count);
        IPropertySelectionModel model = this.getModel();
        for (int i = 0; i < count; ++i) {
            Object value = values[i];
            Object option = model.translateValue((String)value);
            selected.add(option);
        }
        this.setSelected(selected);
        try {
            this.getValidatableFieldSupport().validate((ValidatableField)this, writer, cycle, selected);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._symbols = null;
        this.setAvailableColumn(null);
        this.setSelectedColumn(null);
        super.cleanupAfterRender(cycle);
    }

    private void runScript(IRequestCycle cycle) {
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        this.setImage(pageRenderSupport, cycle, "selectImage", this.getSelectImage());
        this.setImage(pageRenderSupport, cycle, "selectDisabledImage", this.getSelectDisabledImage());
        this.setImage(pageRenderSupport, cycle, "deselectImage", this.getDeselectImage());
        this.setImage(pageRenderSupport, cycle, "deselectDisabledImage", this.getDeselectDisabledImage());
        if (this.isSortUser()) {
            this.setImage(pageRenderSupport, cycle, "upImage", this.getUpImage());
            this.setImage(pageRenderSupport, cycle, "upDisabledImage", this.getUpDisabledImage());
            this.setImage(pageRenderSupport, cycle, "downImage", this.getDownImage());
            this.setImage(pageRenderSupport, cycle, "downDisabledImage", this.getDownDisabledImage());
        }
        this._symbols.put("palette", this);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, this._symbols);
    }

    private void setImage(PageRenderSupport pageRenderSupport, IRequestCycle cycle, String symbolName, IAsset asset) {
        String URL2 = asset.buildURL();
        String reference = pageRenderSupport.getPreloadedImageReference(URL2);
        this._symbols.put(symbolName, reference);
    }

    public Map getSymbols() {
        return this._symbols;
    }

    private void constructColumns() {
        List selected = this.getSelected();
        if (selected == null) {
            selected = Collections.EMPTY_LIST;
        }
        String sortMode = this.getSort();
        boolean sortUser = sortMode.equals("USER");
        ArrayList<PaletteOption> selectedOptions = null;
        if (sortUser) {
            int count = selected.size();
            selectedOptions = new ArrayList<PaletteOption>(count);
            for (int i = 0; i < count; ++i) {
                selectedOptions.add(null);
            }
        }
        PaletteColumn availableColumn = new PaletteColumn((String)this._symbols.get("availableName"), null, this.getRows());
        PaletteColumn selectedColumn = new PaletteColumn(this.getName(), this.getClientId(), this.getRows());
        IPropertySelectionModel model = this.getModel();
        int count = model.getOptionCount();
        for (int i = 0; i < count; ++i) {
            boolean isSelected;
            Object optionValue = model.getOption(i);
            PaletteOption o = new PaletteOption(model.getValue(i), model.getLabel(i));
            int index = selected.indexOf(optionValue);
            boolean bl = isSelected = index >= 0;
            if (sortUser && isSelected) {
                selectedOptions.set(index, o);
                continue;
            }
            PaletteColumn c = isSelected ? selectedColumn : availableColumn;
            c.addOption(o);
        }
        if (sortUser) {
            Iterator i = selectedOptions.iterator();
            while (i.hasNext()) {
                PaletteOption o = (PaletteOption)i.next();
                selectedColumn.addOption(o);
            }
        }
        if (sortMode.equals("VALUE")) {
            availableColumn.sortByValue();
            selectedColumn.sortByValue();
        } else if (sortMode.equals("LABEL")) {
            availableColumn.sortByLabel();
            selectedColumn.sortByLabel();
        }
        this.setAvailableColumn(availableColumn);
        this.setSelectedColumn(selectedColumn);
    }

    public boolean isSortUser() {
        return this.getSort().equals("USER");
    }

    public abstract Block getAvailableTitleBlock();

    public abstract IAsset getDeselectDisabledImage();

    public abstract IAsset getDeselectImage();

    public abstract IAsset getDownDisabledImage();

    public abstract IAsset getDownImage();

    public abstract IAsset getSelectDisabledImage();

    public abstract IPropertySelectionModel getModel();

    public abstract int getRows();

    public abstract Block getSelectedTitleBlock();

    public abstract IAsset getSelectImage();

    public abstract String getSort();

    public abstract IAsset getUpDisabledImage();

    public abstract IAsset getUpImage();

    public boolean isDisabled() {
        return false;
    }

    public abstract List getSelected();

    public abstract void setSelected(List var1);

    public abstract IScript getScript();

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired((ValidatableField)this);
    }

    public abstract /* synthetic */ Object getValidators();

    public abstract /* synthetic */ String getClientId();

    public abstract /* synthetic */ String getDisplayName();

    public abstract /* synthetic */ String getName();

    public abstract /* synthetic */ IForm getForm();
}

