/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.components.inserted;

import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableModel;
import org.apache.tapestry.contrib.table.model.ITableModelSource;
import org.apache.tapestry.contrib.table.model.ITableRendererListener;
import org.apache.tapestry.contrib.table.model.ITableSortingState;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumn;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.util.ComponentAddress;

public abstract class SimpleTableColumnComponent
extends BaseComponent
implements ITableRendererListener,
PageDetachListener {
    private ITableColumn m_objColumn;
    private ITableModelSource m_objModelSource;

    public SimpleTableColumnComponent() {
        this.init();
    }

    public void pageDetached(PageEvent arg0) {
        this.init();
    }

    private void init() {
        this.m_objColumn = null;
        this.m_objModelSource = null;
    }

    public void initializeRenderer(IRequestCycle objCycle, ITableModelSource objSource, ITableColumn objColumn, Object objRow) {
        this.m_objModelSource = objSource;
        this.m_objColumn = objColumn;
    }

    public ITableModel getTableModel() {
        return this.m_objModelSource.getTableModel();
    }

    public boolean getColumnSorted() {
        return this.m_objColumn.getSortable();
    }

    public String getDisplayName() {
        if (this.m_objColumn instanceof SimpleTableColumn) {
            SimpleTableColumn objSimpleColumn = (SimpleTableColumn)this.m_objColumn;
            return objSimpleColumn.getDisplayName();
        }
        return this.m_objColumn.getColumnName();
    }

    public boolean getIsSorted() {
        ITableSortingState objSortingState = this.getTableModel().getSortingState();
        String strSortColumn = objSortingState.getSortColumn();
        return this.m_objColumn.getColumnName().equals(strSortColumn);
    }

    public IAsset getSortImage() {
        IAsset objImageAsset;
        IRequestCycle objCycle = this.getPage().getRequestCycle();
        ITableSortingState objSortingState = this.getTableModel().getSortingState();
        if (!objSortingState.getSortOrder()) {
            objImageAsset = (IAsset)objCycle.getAttribute("org.apache.tapestry.contrib.table.components.TableColumns.arrowUp");
            if (objImageAsset == null) {
                objImageAsset = this.getAsset("sortUp");
            }
        } else {
            objImageAsset = (IAsset)objCycle.getAttribute("org.apache.tapestry.contrib.table.components.TableColumns.arrowDown");
            if (objImageAsset == null) {
                objImageAsset = this.getAsset("sortDown");
            }
        }
        return objImageAsset;
    }

    public Object[] getColumnSelectedParameters() {
        return new Object[]{new ComponentAddress((IComponent)this.m_objModelSource), this.m_objColumn.getColumnName()};
    }

    public void columnSelected(IRequestCycle objCycle) {
        ComponentAddress objAddr;
        ITableModelSource objSource;
        ITableModel objModel;
        ITableSortingState objState;
        Object[] arrArgs = objCycle.getListenerParameters();
        String strColumnName = (String)arrArgs[1];
        if (strColumnName.equals((objState = (objModel = (objSource = (ITableModelSource)(objAddr = (ComponentAddress)arrArgs[0]).findComponent(objCycle)).getTableModel()).getSortingState()).getSortColumn())) {
            objState.setSortColumn(strColumnName, !objState.getSortOrder());
        } else {
            objState.setSortColumn(strColumnName, false);
        }
        objSource.fireObservedStateChange();
    }
}

