/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result.loader;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.result.loader.ResultLoader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;

public class LazyResultLoader
implements InvocationHandler {
    private static final Class[] LIST_INTERFACES = new Class[]{class$java$util$List == null ? (class$java$util$List = LazyResultLoader.class$("java.util.List")) : class$java$util$List};
    protected ExtendedSqlMapClient client;
    protected String statementName;
    protected Object parameterObject;
    protected Class targetType;
    protected boolean loaded;
    protected Object resultObject;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Collection;

    public LazyResultLoader(ExtendedSqlMapClient client, String statementName, Object parameterObject, Class targetType) {
        this.client = client;
        this.statementName = statementName;
        this.parameterObject = parameterObject;
        this.targetType = targetType;
    }

    public Object loadResult() throws SQLException {
        if ((class$java$util$Collection == null ? (class$java$util$Collection = LazyResultLoader.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.targetType)) {
            LazyResultLoader handler = new LazyResultLoader(this.client, this.statementName, this.parameterObject, this.targetType);
            ClassLoader cl = this.targetType.getClassLoader();
            return Proxy.newProxyInstance(cl, LIST_INTERFACES, (InvocationHandler)handler);
        }
        return ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
    }

    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if ("finalize".hashCode() == method.getName().hashCode() && "finalize".equals(method.getName())) {
            return null;
        }
        this.loadObject();
        if (this.resultObject != null) {
            try {
                return method.invoke(this.resultObject, objects);
            }
            catch (Throwable t) {
                throw ClassInfo.unwrapThrowable((Throwable)t);
            }
        }
        return null;
    }

    private synchronized void loadObject() {
        if (!this.loaded) {
            try {
                this.loaded = true;
                this.resultObject = ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
            }
            catch (SQLException e) {
                throw new NestedRuntimeException("Error lazy loading result. Cause: " + e, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

