/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.io.ReaderInputStream;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.BaseStatement;
import com.ibatis.sqlmap.engine.mapping.statement.DefaultRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class GeneralStatement
extends BaseStatement {
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$DomTypeMarker;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$XmlTypeMarker;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public StatementType getStatementType() {
        return StatementType.UNKNOWN;
    }

    public int executeUpdate(RequestScope request, Transaction trans, Object parameterObject) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        request.getSession().setCommitRequired(true);
        try {
            parameterObject = this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(request, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(request, parameterObject);
            request.setResultMap(resultMap);
            request.setParameterMap(parameterMap);
            int rows = 0;
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(request, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(request, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the statement or the result map.");
            rows = this.sqlExecuteUpdate(request, trans.getConnection(), sqlString, parameters);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(request, parameterObject, parameters);
            }
            errorContext.reset();
            sql.cleanup(request);
            this.notifyListeners();
            return rows;
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), (Throwable)e);
        }
    }

    public Object executeQueryForObject(RequestScope request, Transaction trans, Object parameterObject, Object resultObject) throws SQLException {
        try {
            Object object = null;
            DefaultRowHandler rowHandler = new DefaultRowHandler();
            this.executeQueryWithCallback(request, trans.getConnection(), parameterObject, resultObject, rowHandler, 0, -999999);
            List list = rowHandler.getList();
            if (list.size() > 1) {
                throw new SQLException("Error: executeQueryForObject returned too many results.");
            }
            if (list.size() > 0) {
                object = list.get(0);
            }
            return object;
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + (Object)((Object)e), (Throwable)((Object)e));
        }
    }

    public List executeQueryForList(RequestScope request, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        try {
            DefaultRowHandler rowHandler = new DefaultRowHandler();
            this.executeQueryWithCallback(request, trans.getConnection(), parameterObject, null, rowHandler, skipResults, maxResults);
            return rowHandler.getList();
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + (Object)((Object)e), (Throwable)((Object)e));
        }
    }

    public void executeQueryWithRowHandler(RequestScope request, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        try {
            this.executeQueryWithCallback(request, trans.getConnection(), parameterObject, null, rowHandler, 0, -999999);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + (Object)((Object)e), (Throwable)((Object)e));
        }
    }

    protected void executeQueryWithCallback(RequestScope request, Connection conn, Object parameterObject, Object resultObject, RowHandler rowHandler, int skipResults, int maxResults) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        try {
            parameterObject = this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(request, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(request, parameterObject);
            request.setResultMap(resultMap);
            request.setParameterMap(parameterMap);
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(request, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(request, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the SQL statement or the result map.");
            RowHandlerCallback callback = new RowHandlerCallback(resultMap, resultObject, rowHandler);
            this.sqlExecuteQuery(request, conn, sqlString, parameters, skipResults, maxResults, callback);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(request, parameterObject, parameters);
            }
            errorContext.reset();
            sql.cleanup(request);
            this.notifyListeners();
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), (Throwable)e);
        }
    }

    protected void postProcessParameterObject(RequestScope request, Object parameterObject, Object[] parameters) {
    }

    protected int sqlExecuteUpdate(RequestScope request, Connection conn, String sqlString, Object[] parameters) throws SQLException {
        if (request.getSession().isInBatch()) {
            this.getSqlExecutor().addBatch(request, conn, sqlString, parameters);
            return 0;
        }
        return this.getSqlExecutor().executeUpdate(request, conn, sqlString, parameters);
    }

    protected void sqlExecuteQuery(RequestScope request, Connection conn, String sqlString, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        this.getSqlExecutor().executeQuery(request, conn, sqlString, parameters, skipResults, maxResults, callback);
    }

    protected Object validateParameter(Object param) throws SQLException {
        Object newParam = param;
        Class parameterClass = this.getParameterClass();
        if (newParam != null && parameterClass != null) {
            if ((class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomTypeMarker = GeneralStatement.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomTypeMarker).isAssignableFrom(parameterClass)) {
                if ((class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = GeneralStatement.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).isAssignableFrom(parameterClass)) {
                    if (!(newParam instanceof String) && !(newParam instanceof Document)) {
                        throw new SQLException("Invalid parameter object type.  Expected '" + (class$java$lang$String == null ? (class$java$lang$String = GeneralStatement.class$("java.lang.String")) : class$java$lang$String).getName() + "' or '" + (class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = GeneralStatement.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).getName() + "' but found '" + newParam.getClass().getName() + "'.");
                    }
                    if (!(newParam instanceof Document)) {
                        newParam = this.stringToDocument((String)newParam);
                    }
                } else if (!(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = GeneralStatement.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).isAssignableFrom(newParam.getClass())) {
                    throw new SQLException("Invalid parameter object type.  Expected '" + (class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = GeneralStatement.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).getName() + "' but found '" + newParam.getClass().getName() + "'.");
                }
            } else if (!parameterClass.isAssignableFrom(newParam.getClass())) {
                throw new SQLException("Invalid parameter object type.  Expected '" + parameterClass.getName() + "' but found '" + newParam.getClass().getName() + "'.");
            }
        }
        return newParam;
    }

    private Document stringToDocument(String s) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse((InputStream)new ReaderInputStream((Reader)new StringReader(s)));
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Error occurred.  Cause: " + e, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

