/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.services.NamespaceResources;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.ILibrarySpecification;

public class Namespace
implements INamespace {
    private final ILibrarySpecification _specification;
    private final String _id;
    private String _extendedId;
    private final INamespace _parent;
    private final boolean _frameworkNamespace;
    private final boolean _applicationNamespace;
    private final NamespaceResources _resources;
    private final Map _pages = Collections.synchronizedMap(new HashMap());
    private final Map _components = Collections.synchronizedMap(new HashMap());
    private final Map _children = Collections.synchronizedMap(new HashMap());

    public Namespace(String id, INamespace parent, ILibrarySpecification specification, NamespaceResources resources) {
        this._id = id;
        this._parent = parent;
        this._specification = specification;
        this._resources = resources;
        this._applicationNamespace = this._id == null;
        this._frameworkNamespace = "framework".equals(this._id);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Namespace@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        if (this._applicationNamespace) {
            buffer.append("<application>");
        } else {
            buffer.append(this.getExtendedId());
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String getId() {
        return this._id;
    }

    public String getExtendedId() {
        if (this._applicationNamespace) {
            return null;
        }
        if (this._extendedId == null) {
            this._extendedId = this.buildExtendedId();
        }
        return this._extendedId;
    }

    public INamespace getParentNamespace() {
        return this._parent;
    }

    public INamespace getChildNamespace(String id) {
        INamespace result;
        String firstId = id;
        String nextIds = null;
        int index = id.indexOf(46);
        if (index >= 0) {
            firstId = id.substring(0, index);
            nextIds = id.substring(index + 1);
        }
        if ((result = (INamespace)this._children.get(firstId)) == null) {
            result = this.createNamespace(firstId);
            this._children.put(firstId, result);
        }
        if (result != null && nextIds != null) {
            result = result.getChildNamespace(nextIds);
        }
        return result;
    }

    public List getChildIds() {
        return this._specification.getLibraryIds();
    }

    public IComponentSpecification getPageSpecification(String name) {
        IComponentSpecification result = (IComponentSpecification)this._pages.get(name);
        if (result == null) {
            result = this.locatePageSpecification(name);
            this._pages.put(name, result);
        }
        return result;
    }

    public List getPageNames() {
        HashSet names = new HashSet();
        names.addAll(this._pages.keySet());
        names.addAll(this._specification.getPageNames());
        ArrayList result = new ArrayList(names);
        Collections.sort(result);
        return result;
    }

    public IComponentSpecification getComponentSpecification(String alias) {
        IComponentSpecification result = (IComponentSpecification)this._components.get(alias);
        if (result == null) {
            result = this.locateComponentSpecification(alias);
            this._components.put(alias, result);
        }
        return result;
    }

    public ILibrarySpecification getSpecification() {
        return this._specification;
    }

    private String buildExtendedId() {
        if (this._parent == null) {
            return this._id;
        }
        String parentId = this._parent.getExtendedId();
        if (parentId == null) {
            return this._id;
        }
        return parentId + "." + this._id;
    }

    public String getNamespaceId() {
        if (this._frameworkNamespace) {
            return Tapestry.getMessage("Namespace.framework-namespace");
        }
        if (this._applicationNamespace) {
            return Tapestry.getMessage("Namespace.application-namespace");
        }
        return Tapestry.format("Namespace.nested-namespace", this.getExtendedId());
    }

    private IComponentSpecification locatePageSpecification(String name) {
        String path = this._specification.getPageSpecificationPath(name);
        if (path == null) {
            throw new ApplicationRuntimeException(Tapestry.format("Namespace.no-such-page", name, this.getNamespaceId()));
        }
        return this._resources.getPageSpecification(this.getSpecificationLocation(), path, this.getLocation());
    }

    private IComponentSpecification locateComponentSpecification(String type) {
        String path = this._specification.getComponentSpecificationPath(type);
        if (path == null) {
            throw new ApplicationRuntimeException(Tapestry.format("Namespace.no-such-alias", type, this.getNamespaceId()));
        }
        return this._resources.getComponentSpecification(this.getSpecificationLocation(), path, this.getLocation());
    }

    private INamespace createNamespace(String id) {
        String path = this._specification.getLibrarySpecificationPath(id);
        if (path == null) {
            throw new ApplicationRuntimeException(Tapestry.format("Namespace.library-id-not-found", id, this.getNamespaceId()));
        }
        ILibrarySpecification ls = this._resources.findChildLibrarySpecification(this.getSpecificationLocation(), path, this.getLocation());
        return new Namespace(id, this, ls, this._resources);
    }

    public synchronized boolean containsPage(String name) {
        return this._pages.containsKey(name) || this._specification.getPageSpecificationPath(name) != null;
    }

    public String constructQualifiedName(String pageName) {
        String prefix = this.getExtendedId();
        if (prefix == null) {
            return pageName;
        }
        return prefix + ':' + pageName;
    }

    public Resource getSpecificationLocation() {
        return this._specification.getSpecificationLocation();
    }

    public boolean isApplicationNamespace() {
        return this._applicationNamespace;
    }

    public synchronized void installPageSpecification(String pageName, IComponentSpecification specification) {
        this._pages.put(pageName, specification);
    }

    public synchronized void installComponentSpecification(String type, IComponentSpecification specification) {
        this._components.put(type, specification);
    }

    public synchronized boolean containsComponentType(String type) {
        return this._components.containsKey(type) || this._specification.getComponentSpecificationPath(type) != null;
    }

    public Location getLocation() {
        if (this._specification == null) {
            return null;
        }
        return this._specification.getLocation();
    }

    public String getPropertyValue(String propertyName) {
        return this._specification.getProperty(propertyName);
    }
}

