/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.describe.ReportStatusHub;
import org.apache.tapestry.web.WebUtils;

public abstract class RequestDisplay
extends BaseComponent {
    private boolean _even;

    public abstract ReportStatusHub getReportStatusHub();

    public void renderSystemProperties(IMarkupWriter writer) {
        this._even = true;
        Properties p = System.getProperties();
        String pathSeparator = p.getProperty("path.separator");
        writer.begin("div");
        writer.attribute("class", "described-object-title");
        writer.print("JVM System Properties");
        writer.end();
        writer.println();
        writer.begin("table");
        writer.attribute("class", "described-object");
        Iterator i = WebUtils.toSortedList(((Hashtable)p).keys()).iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = p.getProperty(key);
            this.renderKeyAndValue(writer, key, value, pathSeparator);
        }
        writer.end();
    }

    private void renderKeyAndValue(IMarkupWriter writer, String key, String value, String pathSeparator) {
        String[] values = this.split(key, value, pathSeparator);
        for (int i = 0; i < values.length; ++i) {
            writer.begin("tr");
            writer.attribute("class", this._even ? "even" : "odd");
            this._even = !this._even;
            writer.begin("th");
            if (i == 0) {
                writer.print(key);
            }
            writer.end();
            writer.begin("td");
            writer.print(values[i]);
            writer.end("tr");
            writer.println();
        }
    }

    private String[] split(String key, String value, String pathSeparator) {
        if (!key.endsWith(".path")) {
            return new String[]{value};
        }
        StringTokenizer tokenizer = new StringTokenizer(value, pathSeparator);
        ArrayList<Object> values = Collections.list(tokenizer);
        return values.toArray(new String[values.size()]);
    }

    public IRender getSystemPropertiesRenderer() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) {
                RequestDisplay.this.renderSystemProperties(writer);
            }
        };
    }

    public IRender getReportStatusRenderer() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) {
                RequestDisplay.this.getReportStatusHub().fireReportStatus(writer);
            }
        };
    }
}

