/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.LocationImpl;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.util.RegexpMatcher;
import org.apache.tapestry.util.xml.DocumentParseException;
import org.apache.tapestry.util.xml.IRule;
import org.apache.tapestry.util.xml.InvalidStringException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RuleDirectedParser
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$util$xml$RuleDirectedParser == null ? (class$org$apache$tapestry$util$xml$RuleDirectedParser = RuleDirectedParser.class$("org.apache.tapestry.util.xml.RuleDirectedParser")) : class$org$apache$tapestry$util$xml$RuleDirectedParser));
    private Resource _documentLocation;
    private List _ruleStack = new ArrayList();
    private List _objectStack = new ArrayList();
    private Object _documentObject;
    private Locator _locator;
    private int _line = -1;
    private int _column = -1;
    private Location _location;
    private static SAXParserFactory _parserFactory;
    private SAXParser _parser;
    private RegexpMatcher _matcher;
    private String _uri;
    private String _localName;
    private String _qName;
    private Map _ruleMap = new HashMap();
    private StringBuffer _contentBuffer = new StringBuffer();
    private Map _entities = new HashMap();
    static /* synthetic */ Class class$org$apache$tapestry$util$xml$RuleDirectedParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Resource documentLocation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing: " + documentLocation));
        }
        try {
            this._documentLocation = documentLocation;
            URL url = documentLocation.getResourceURL();
            if (url == null) {
                throw new DocumentParseException(Tapestry.format("RuleDrivenParser.resource-missing", documentLocation), documentLocation);
            }
            Object object = this.parse(url);
            Object var5_4 = null;
            this._documentLocation = null;
            this._ruleStack.clear();
            this._objectStack.clear();
            this._documentObject = null;
            this._uri = null;
            this._localName = null;
            this._qName = null;
            this._line = -1;
            this._column = -1;
            this._location = null;
            this._locator = null;
            this._contentBuffer.setLength(0);
            return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._documentLocation = null;
            this._ruleStack.clear();
            this._objectStack.clear();
            this._documentObject = null;
            this._uri = null;
            this._localName = null;
            this._qName = null;
            this._line = -1;
            this._column = -1;
            this._location = null;
            this._locator = null;
            this._contentBuffer.setLength(0);
            throw throwable;
        }
    }

    protected Object parse(URL url) {
        if (this._parser == null) {
            this._parser = this.constructParser();
        }
        InputStream stream = null;
        try {
            stream = url.openStream();
        }
        catch (IOException ex) {
            throw new DocumentParseException(Tapestry.format("RuleDrivenParser.unable-to-open-resource", url), this._documentLocation, (Throwable)ex);
        }
        InputSource source = new InputSource(stream);
        try {
            this._parser.parse(source, (DefaultHandler)this);
            stream.close();
        }
        catch (Exception ex) {
            throw new DocumentParseException(Tapestry.format("RuleDrivenParser.parse-error", url, ex.getMessage()), this.getLocation(), (Throwable)ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Document parsed as: " + this._documentObject));
        }
        return this._documentObject;
    }

    public Location getLocation() {
        if (this._locator == null) {
            return null;
        }
        int line = this._locator.getLineNumber();
        int column = this._locator.getColumnNumber();
        if (this._line != line || this._column != column) {
            this._location = null;
            this._line = line;
            this._column = column;
        }
        if (this._location == null) {
            this._location = new LocationImpl(this._documentLocation, this._line, this._column);
        }
        return this._location;
    }

    public void push(Object object) {
        if (this._documentObject == null) {
            this._documentObject = object;
        }
        this.push(this._objectStack, object, "object stack");
    }

    public Object peek() {
        return this.peek(this._objectStack, 0);
    }

    public Object peek(int depth) {
        return this.peek(this._objectStack, depth);
    }

    public Object pop() {
        return this.pop(this._objectStack, "object stack");
    }

    private Object pop(List list, String name) {
        Object result = list.remove(list.size() - 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Popped " + result + " off " + name + " (at " + this.getLocation() + ")"));
        }
        return result;
    }

    private Object peek(List list, int depth) {
        return list.get(list.size() - 1 - depth);
    }

    private void push(List list, Object object, String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Pushing " + object + " onto " + name + " (at " + this.getLocation() + ")"));
        }
        list.add(object);
    }

    protected void pushRule(IRule rule) {
        this.push(this._ruleStack, rule, "rule stack");
    }

    protected IRule peekRule() {
        return (IRule)this.peek(this._ruleStack, 0);
    }

    protected IRule popRule() {
        return (IRule)this.pop(this._ruleStack, "rule stack");
    }

    public void addRule(String localElementName, IRule rule) {
        this._ruleMap.put(localElementName, rule);
    }

    public void registerEntity(String publicId, String entityPath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering " + publicId + " as " + entityPath));
        }
        if (this._entities == null) {
            this._entities = new HashMap();
        }
        this._entities.put(publicId, entityPath);
    }

    protected IRule selectRule(String localName, Attributes attributes) {
        IRule rule = (IRule)this._ruleMap.get(localName);
        if (rule == null) {
            throw new DocumentParseException(Tapestry.format("RuleDrivenParser.no-rule-for-element", localName), this.getLocation());
        }
        return rule;
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this._contentBuffer.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.fireContentRule();
        this._uri = uri;
        this._localName = localName;
        this._qName = qName;
        this.popRule().endElement(this);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.fireContentRule();
        this._uri = uri;
        this._localName = localName;
        this._qName = qName;
        String name = this.extractName(uri, localName, qName);
        IRule newRule = this.selectRule(name, attributes);
        this.pushRule(newRule);
        newRule.startElement(this, attributes);
    }

    private String extractName(String uri, String localName, String qName) {
        return HiveMind.isBlank((String)localName) ? qName : localName;
    }

    protected synchronized SAXParser constructParser() {
        if (_parserFactory == null) {
            _parserFactory = SAXParserFactory.newInstance();
            this.configureParserFactory(_parserFactory);
        }
        try {
            return _parserFactory.newSAXParser();
        }
        catch (SAXException ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
    }

    protected void configureParserFactory(SAXParserFactory factory) {
        factory.setValidating(true);
        factory.setNamespaceAware(false);
    }

    public void error(SAXParseException ex) throws SAXException {
        this.fatalError(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this._parser = null;
        throw ex;
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.fatalError(ex);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String entityPath = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to resolve entity; publicId = " + publicId + " systemId = " + systemId));
        }
        if (this._entities != null) {
            entityPath = (String)this._entities.get(publicId);
        }
        if (entityPath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Entity not found, using " + systemId));
            }
            return null;
        }
        InputStream stream = this.getClass().getResourceAsStream(entityPath);
        InputSource result = new InputSource(stream);
        if (result != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved " + publicId + " as " + result + " (for " + entityPath + ")"));
        }
        return result;
    }

    public void validate(String value, String pattern, String errorKey) throws DocumentParseException {
        if (this._matcher == null) {
            this._matcher = new RegexpMatcher();
        }
        if (this._matcher.matches(pattern, value)) {
            return;
        }
        throw new InvalidStringException(Tapestry.format(errorKey, value), value, this.getLocation());
    }

    public Resource getDocumentLocation() {
        return this._documentLocation;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getQName() {
        return this._qName;
    }

    public String getUri() {
        return this._uri;
    }

    private void fireContentRule() {
        String content = this._contentBuffer.toString();
        this._contentBuffer.setLength(0);
        if (!this._ruleStack.isEmpty()) {
            this.peekRule().content(this, content);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

