/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.AbstractNumericValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class IntValidator
extends AbstractNumericValidator {
    private boolean _minimumSet;
    private int _minimum;
    private boolean _maximumSet;
    private int _maximum;

    public IntValidator() {
    }

    public IntValidator(String initializer) {
        super(initializer);
    }

    public String toString(IFormComponent field, Object value) {
        if (value == null) {
            return null;
        }
        Number number = (Number)value;
        if (this.getZeroIsNull() && number.intValue() == 0) {
            return null;
        }
        return number.toString();
    }

    public Object toObject(IFormComponent field, String value) throws ValidatorException {
        if (this.checkRequired(field, value)) {
            return null;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (this._minimumSet && intValue < this._minimum) {
                throw new ValidatorException(this.buildNumberTooSmallMessage(field, new Integer(this._minimum)), ValidationConstraint.TOO_SMALL);
            }
            if (this._maximumSet && intValue > this._maximum) {
                throw new ValidatorException(this.buildNumberTooLargeMessage(field, new Integer(this._maximum)), ValidationConstraint.TOO_LARGE);
            }
            return new Integer(intValue);
        }
        catch (NumberFormatException ex) {
            throw new ValidatorException(this.buildInvalidNumericFormatMessage(field), ValidationConstraint.NUMBER_FORMAT);
        }
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        if (!(this.isRequired() || this._minimumSet || this._maximumSet)) {
            return;
        }
        Map symbols = this.buildSymbols(field);
        this.processValidatorScript(this.getScriptPath(), cycle, field, symbols);
    }

    Map buildSymbols(IFormComponent field) {
        HashMap<String, Object> symbols = new HashMap<String, Object>();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.buildRequiredMessage(field));
        }
        symbols.put("formatMessage", this.buildInvalidIntegerFormatMessage(field));
        if (this._minimumSet || this._maximumSet) {
            Integer minimum = this._minimumSet ? new Integer(this._minimum) : null;
            Integer maximum = this._maximumSet ? new Integer(this._maximum) : null;
            symbols.put("minimum", minimum);
            symbols.put("maximum", maximum);
            symbols.put("rangeMessage", this.buildRangeMessage(field, minimum, maximum));
        }
        return symbols;
    }

    public void setMaximum(int maximum) {
        this._maximum = maximum;
        this._maximumSet = true;
    }

    public void setMinimum(int minimum) {
        this._minimum = minimum;
        this._minimumSet = true;
    }

    protected String getDefaultScriptPath() {
        return "/org/apache/tapestry/valid/IntegerValidator.script";
    }
}

