/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.plugin.google.ui.views;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import nu.mine.kino.googleapis.ResultElement;
import nu.mine.kino.plugin.google.ui.GooglePlugin;
import nu.mine.kino.plugin.google.ui.Utility;
import nu.mine.kino.plugin.google.ui.views.SearchJob;
import nu.mine.kino.plugin.google.ui.views.fields.IField;
import nu.mine.kino.plugin.google.ui.views.fields.SummaryField;
import nu.mine.kino.plugin.google.ui.views.fields.TitleField;
import nu.mine.kino.plugin.google.ui.views.fields.URLField;
import nu.mine.kino.plugin.google.ui.views.internal.TableSorter;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ViewPart;

public class GoogleResultView
extends ViewPart {
    private Action clearAction;
    private TableSorter sorter;
    private static final Logger logger;
    private TableViewer viewer;
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    private final ColumnPixelData[] DEFAULT_COLUMN_LAYOUTS = new ColumnPixelData[]{new ColumnPixelData(200), new ColumnPixelData(200), new ColumnPixelData(200)};
    private final IField[] VISIBLE_FIELDS = new IField[]{new TitleField(), new SummaryField(), new URLField()};
    private Table table;
    private Action doubleClickAction;
    private Action openBrowserAction;
    private IMemento memento;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("nu.mine.kino.plugin.google.ui.views.GoogleResultView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(container, 68352);
        this.viewer.setSorter((ViewerSorter)this.getSorter());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                GoogleResultView.this.doubleClickAction.run();
            }
        });
        int dragOption = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
        this.viewer.addDragSupport(dragOption, transfers, (DragSourceListener)new DragSourceAdapterImpl((StructuredViewer)this.viewer));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(this.VISIBLE_FIELDS));
        this.viewer.setInput((Object)this.getViewSite());
        this.initTable(this.viewer);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GoogleResultView.this.fillContextMenu(manager);
                ISelection selection = GoogleResultView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj == null) {
                    GoogleResultView.this.openBrowserAction.setEnabled(false);
                } else {
                    GoogleResultView.this.openBrowserAction.setEnabled(true);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openBrowserAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private void initTable(TableViewer viewer) {
        SelectionListener headerListener = this.getHeaderListener();
        this.table = viewer.getTable();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        ColumnLayoutData[] columnLayouts = this.getColumnLayouts();
        int i = 0;
        while (i < columnLayouts.length) {
            layout.addColumnData(columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setText(this.VISIBLE_FIELDS[i].getColumnHeaderText());
            tc.setImage(this.VISIBLE_FIELDS[i].getColumnHeaderImage());
            tc.addSelectionListener(headerListener);
            ++i;
        }
    }

    private ColumnLayoutData[] getColumnLayouts() {
        ColumnPixelData[] result = new ColumnPixelData[this.DEFAULT_COLUMN_LAYOUTS.length];
        int i = 0;
        while (i < this.DEFAULT_COLUMN_LAYOUTS.length) {
            Integer widthInt;
            int width = this.DEFAULT_COLUMN_LAYOUTS[i].width;
            if (this.memento != null && (widthInt = this.memento.getInteger(TAG_COLUMN_WIDTH + i)) != null && widthInt > 0) {
                width = widthInt;
            }
            result[i] = new ColumnPixelData(width);
            ++i;
        }
        return result;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.saveColumnWidth(memento);
    }

    private void saveColumnWidth(IMemento memento) {
        TableColumn[] columns = this.viewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            memento.putInteger(TAG_COLUMN_WIDTH + i, columns[i].getWidth());
            ++i;
        }
    }

    public void search(String text) {
        SearchJob job = new SearchJob("Google Search", text, this.viewer);
        job.setUser(true);
        job.schedule();
    }

    private void createActions() {
        this.openBrowserAction = new Action("\u30b5\u30a4\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b"){

            public void run() {
                ISelection selection = GoogleResultView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    ResultElement element = (ResultElement)obj;
                    GoogleResultView.this.executeBrowser(element.getURL());
                }
            }
        };
        this.openBrowserAction.setToolTipText("\u30b5\u30a4\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b");
        this.openBrowserAction.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"home.gif"));
        this.doubleClickAction = new Action(""){

            public void run() {
                ISelection selection = GoogleResultView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ResultElement element = (ResultElement)obj;
                GoogleResultView.this.executeBrowser(element.getURL());
            }
        };
        this.clearAction = new Action("\u30af\u30ea\u30a2"){

            public void run() {
                GoogleResultView.this.viewer.setInput(new Object());
            }
        };
        this.clearAction.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"clear.gif"));
    }

    private void executeBrowser(String url) {
        Program program = Program.findProgram((String)"html");
        logger.debug((Object)("\u6b21\u306eURL\u3092\u958b\u304d\u307e\u3059\uff1a " + url));
        if (program != null) {
            program.execute(url);
        } else {
            logger.warn((Object)"\u30d6\u30e9\u30a6\u30b6\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002OS\u306e\u30d0\u30b0\u304f\u305b\u3047\u306a\u3041");
            logger.debug((Object)"\u4ed5\u65b9\u304c\u306a\u3044\u306e\u3067\u3001Windows\u5c02\u7528\u306e\u3084\u308a\u65b9\u3067\u3084\u308a\u307e\u3059\u3002");
            try {
                Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url});
            }
            catch (IOException iOException) {
                logger.error((Object)"Windows\u9650\u5b9a\u306e\u3084\u308a\u65b9\u3067\u3082\u3001\u30d6\u30e9\u30a6\u30b6\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002OS\u306e\u30d0\u30b0\u304f\u305b\u3047\u306a\u3041");
            }
        }
    }

    private void initializeToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.clearAction);
        tbm.add((IAction)this.openBrowserAction);
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = GoogleResultView.this.viewer.getTable().indexOf((TableColumn)e.widget);
                if (column == GoogleResultView.this.getSorter().getTopPriority()) {
                    GoogleResultView.this.getSorter().reverseTopPriority();
                } else {
                    GoogleResultView.this.getSorter().setTopPriority(column);
                }
                GoogleResultView.this.setSorter(GoogleResultView.this.getSorter());
            }
        };
    }

    private TableSorter getSorter() {
        if (this.sorter == null) {
            int[] priorities = new int[this.getFields().length];
            int[] directions = new int[this.getFields().length];
            int i = 0;
            while (i < this.getFields().length) {
                priorities[i] = i;
                ++i;
            }
            Arrays.fill(directions, 1);
            this.sorter = new TableSorter(this.getFields(), priorities, directions);
        }
        return this.sorter;
    }

    private void setSorter(TableSorter aSorter) {
        TableSorter newSorter;
        this.sorter = newSorter = new TableSorter(aSorter);
        this.sorterChanged();
    }

    private void sorterChanged() {
        this.viewer.setSorter((ViewerSorter)this.getSorter());
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                GoogleResultView.this.viewer.getControl().setRedraw(false);
                GoogleResultView.this.viewer.refresh(false);
                GoogleResultView.this.viewer.getControl().setRedraw(true);
            }
        });
        logger.debug((Object)"\u30bd\u30fc\u30c8\u51e6\u7406\u304c\u8d70\u308a\u307e\u3057\u305f");
    }

    private IField[] getFields() {
        return this.VISIBLE_FIELDS;
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final Logger logger;
        private final IField[] fields;
        static /* synthetic */ Class class$0;

        public ViewLabelProvider(IField[] fields) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("nu.mine.kino.plugin.google.ui.views.GoogleResultView$ViewLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logger = Logger.getLogger((Class)clazz);
            this.fields = fields;
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ResultElement) {
                ResultElement element = (ResultElement)obj;
                return this.fields[index].getValue(element);
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private class DragSourceAdapterImpl
    extends DragSourceAdapter {
        private StructuredViewer viewer;

        public DragSourceAdapterImpl(StructuredViewer viewer) {
            this.viewer = viewer;
        }

        public void dragSetData(DragSourceEvent event) {
            logger.debug((Object)"dragSetData(DragSourceEvent) - start");
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Object obj = selection.getFirstElement();
            ResultElement element = (ResultElement)obj;
            if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                logger.debug((Object)"FileTransfer event.dataType");
                try {
                    File resultFile = this.createFileFromResultElement(element);
                    event.data = new String[]{resultFile.getAbsolutePath()};
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    GooglePlugin.log(e);
                }
            } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                logger.debug((Object)"TextTransfer event.dataType");
                event.data = element.getTitle();
            } else if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
                logger.debug((Object)"PluginTransfer event.dataType");
            }
            logger.debug((Object)event);
            logger.debug((Object)"dragSetData(DragSourceEvent) - end");
        }

        private File createFileFromResultElement(ResultElement element) throws IOException {
            String name = element.getTitle();
            File resultFile = File.createTempFile(Utility.filter(name), ".url");
            Utility.write(element.getURL(), resultFile);
            logger.debug((Object)resultFile.getAbsolutePath());
            resultFile.deleteOnExit();
            return resultFile;
        }
    }
}

