/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.log4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Log4jPlugin
extends AbstractUIPlugin {
    private static final Logger logger;
    private static Log4jPlugin plugin;
    private ResourceBundle resourceBundle;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("nu.mine.kino.log4j.Log4jPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public Log4jPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("nu.mine.kino.log4j.Log4jPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configure();
    }

    public void configure() {
        String log4jPath = this.getPreferenceStore().getString("log4jPath");
        DOMConfigurator.configure((String)log4jPath);
        logger.debug((Object)(String.valueOf(log4jPath) + " \u3067Log4j\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f\u3002"));
        this.print();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static Log4jPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = Log4jPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void log(String message, Exception e) {
        Status status = new Status(4, Log4jPlugin.getPluginId(), 4, message, (Throwable)e);
        Log4jPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Log4jPlugin.log(message, null);
    }

    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String message = stringWriter.getBuffer().toString();
        Log4jPlugin.log(message, e);
    }

    public static String getPluginId() {
        return Log4jPlugin.getDefault().getBundle().getSymbolicName();
    }

    private void print() {
        Logger rootLogger = Logger.getRootLogger();
        logger.info((Object)"---------------------------------------");
        rootLogger.debug((Object)"Root Logger \u306f DEBUG \u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        rootLogger.info((Object)"Root Logger \u306f INFO  \u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        rootLogger.warn((Object)"Root Logger \u306f WARN  \u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        rootLogger.error((Object)"Root Logger \u306f ERROR \u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        rootLogger.fatal((Object)"Root Logger \u306f FATAL \u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        logger.info((Object)"---------------------------------------");
    }
}

