//$Id: GooglePlugin.java,v 1.1 2005/03/02 13:44:50 cvsuser Exp $
//쐬: 2005/03/02
package nu.mine.kino.plugin.google.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import nu.mine.kino.plugin.google.core.GoogleCorePlugin;
import nu.mine.kino.plugin.google.ui.preferences.PreferenceConstants;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * GoogleWEBT[rXAPIpČsvOCłB
 * 
 * @author Masatomi KINO
 * @version $Revision: 1.1 $
 */
public class GooglePlugin extends AbstractUIPlugin {
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger.getLogger(GooglePlugin.class);

    // The shared instance.
    private static GooglePlugin plugin;

    // Resource bundle.
    private ResourceBundle resourceBundle;

    /**
     * The constructor.
     */
    public GooglePlugin() {
        super();
        plugin = this;
    }

    /**
     * This method is called upon plug-in activation
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        resourceBundle = null;
    }

    /**
     * Returns the shared instance.
     */
    public static GooglePlugin getDefault() {
        return plugin;
    }

    /**
     * Returns the string from the plugin's resource bundle, or 'key' if not
     * found.
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = GooglePlugin.getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Returns the plugin's resource bundle,
     */
    public ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null)
                resourceBundle = ResourceBundle
                        .getBundle("nu.mine.kino.plugin.google.ui.GooglePluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
        return resourceBundle;
    }

    /**
     * Returns an image descriptor for the image file at the given plug-in
     * relative path.
     * 
     * @param path
     *            the path
     * @return the image descriptor
     */
    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin(
                "nu.mine.kino.plugin.google.ui", path);
    }

    public static void log(String message, Exception e) {
        IStatus status = new Status(IStatus.ERROR, getPluginId(),
                IStatus.ERROR, message, e);
        getDefault().getLog().log(status);
    }

    public static void log(String message) {
        log(message, null);
    }

    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String message = stringWriter.getBuffer().toString();
        log(message, e);
    }

    public static String getPluginId() {
        return getDefault().getBundle().getSymbolicName();
    }

    /**
     * ̕GoogleɃNGXgAP̌`FbN܂B
     * ₪ꍇA₪Ԃ܂B₪ȂꍇA͂PꂪԂ܂B
     * 
     * @param text
     * @param monitor
     * @return
     */
    public String getSplellingSuggestion(final String text,
            IProgressMonitor monitor) {
        String searchText;
        String suggestionText = null;

        // ݒʂAGoogle Key擾
        String myGoogleKey = GooglePlugin.getDefault().getPreferenceStore()
                .getString(PreferenceConstants.GOOGLE_KEY);
        // GoogleɃNGXg
        suggestionText = GoogleCorePlugin.getDefault().getSplellingSuggestion(
                myGoogleKey, text);

        // nullłȂꍇ͌₪ԂĂ
        if (suggestionText != null) {
            CheckThread dialog = new CheckThread(text, suggestionText);
            // [UɕύX邩I΂
            checkSyncExec(dialog);
            // dialog茋ʂ擾
            if (dialog.isOK()) {
                // ύX
                searchText = suggestionText;
                logger.debug("Xy~X̌ɕύX܂");
                monitor.setTaskName("u" + suggestionText
                        + "vɕύXGoogle...");
            } else {
                // ύXȂ
                searchText = text;
                logger.debug("Xy~X̌ɕύX܂([ULZ)");
            }
        } else {
            logger.debug("Xy~X̌₪܂ł");
            // Oꍇ̃P[X
            searchText = text;
        }
        return searchText;
    }

    /**
     * vOXo[Ń_CAOoۂɎgpXbhłB
     * 
     * @author Masatomi KINO
     * @see GoogleResultView#checkSyncExec(Runnable)
     */
    private class CheckThread implements Runnable {
        /**
         * Logger for this class
         */
        private final Logger logger = Logger.getLogger(CheckThread.class);

        // _CAOŃ[Uǂ𔻒肷tO
        // 0 : 
        // 1 : Ȃ
        private int returnCode;

        private String text;

        private String suggestionText;

        /**
         * @param text
         * @param suggestionText
         */
        public CheckThread(String text, String suggestionText) {
            this.text = text;
            this.suggestionText = suggestionText;
        }

        public void run() {
            StringBuffer message = new StringBuffer();
            message.append("␳܂H ");
            message.append(text);
            message.append(" -> ");
            message.append(suggestionText);

            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            MessageDialog dialog = new MessageDialog(window.getShell(),
                    "Xy~XĂ܂񂩁H", null, new String(message),
                    MessageDialog.QUESTION, new String[] { "", "Ȃ" }, 1);
            returnCode = dialog.open();
        }

        /**
         * _CAOŃ[Uǂ𔻒肵܂B
         * 
         * @return 0 :  1 : Ȃ
         */
        public boolean isOK() {
            if (returnCode == 0) {
                return true;
            }
            return false;
        }
    }

    private boolean checkSyncExec(Runnable thread) {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(thread);
            return true;
        } else {
            return false;
        }
    }
}
