/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.IOException;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import jp.wda.gpss.system.MainNioPooledThread;
import jp.wda.gpss.system.SocketProcessorBase;

final class SocketProcessorImplNioPooledThread
extends SocketProcessorBase
implements Runnable {
    private SocketChannel channel;
    private Charset codec;
    private ByteBuffer messageBuffer;
    private static final int BUFFER_SIZE = 4096;
    private MainNioPooledThread server;
    private long timeout = 0L;
    private long lastAct = System.currentTimeMillis();
    private boolean terminated = false;

    public SocketProcessorImplNioPooledThread(MainNioPooledThread server, SocketChannel channel, String encoding, int buffersize) throws IOException {
        super(server, encoding, buffersize, channel.socket().getInetAddress().getHostAddress());
        this.server = server;
        this.channel = channel;
        this.codec = server.getCodec();
        this.messageBuffer = ByteBuffer.allocate(4096);
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    boolean isInactive() {
        if (this.timeout == 0L) {
            return false;
        }
        return System.currentTimeMillis() > this.timeout + this.lastAct;
    }

    private void recordActive() {
        this.lastAct = System.currentTimeMillis();
    }

    void terminateIfInactive() {
        if (this.isInactive() && !this.isTerminated()) {
            this.terminate();
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    void setMessage(ByteBuffer buffer) {
        this.recordActive();
        byte b = 0;
        while (buffer.hasRemaining()) {
            b = buffer.get();
            if (b != 0) {
                this.messageBuffer.put(b);
                continue;
            }
            ((Buffer)this.messageBuffer).flip();
            try {
                this.server.getPool().execute((Runnable)new CommandProcessor(this, this.messageBuffer));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.messageBuffer = ByteBuffer.allocate(4096);
        }
    }

    public void run() {
    }

    private void onInitialize(String mesage) {
        try {
            this.getProgress().log("debuglogger", "connection:" + mesage + " [" + this.getClientID() + "]");
            this.doInitialCommand(mesage);
            if (this.getApplication() == null) {
                this.terminate();
                return;
            }
            if (!this.getApplication().checkConnection(this)) {
                this.terminate();
                return;
            }
            this.terminated = false;
            this.channel.socket().setSoTimeout(this.getApplication().getTimeout());
            this.setTimeout(this.getApplication().getTimeout());
        }
        catch (SocketException ioe) {
            this.getProgress().errlog(String.valueOf(ioe.getMessage()) + ":" + this.getClientID());
            this.terminate();
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
        }
    }

    private void onCommand(String message) {
        try {
            if (!this.getApplication().doCommand(this, message)) {
                this.terminate();
            }
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
        }
    }

    public boolean send(String message) {
        if (this.channel == null) {
            this.getProgress().errlog("\u30e9\u30a4\u30bf\u3092\u55aa\u5931\u3057\u307e\u3057\u305f\u3002" + this.getClientID());
            return false;
        }
        try {
            this.channel.write(this.codec.encode(String.valueOf(message) + "\u0000"));
        }
        catch (IOException e) {
            this.getProgress().errlog("\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.getClientID() + "\n" + message, e);
            return false;
        }
        return true;
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.getProgress().log("debuglogger", "disconnect [" + this.getClientID() + "]");
        try {
            if (this.getApplication() != null) {
                this.getApplication().preRemoveClient(this);
                this.getApplication().removeClient(this);
                this.notifyToSystemCommandSocklet();
            }
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
            e.printStackTrace();
        }
        try {
            if (this.channel != null) {
                this.channel.close();
                this.server.getSelector().wakeup();
            }
        }
        catch (IOException e) {
            this.getProgress().errlog("\u30c1\u30e3\u30f3\u30cd\u30eb\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
        }
        this.channel = null;
    }

    public synchronized void terminate(String message) {
        this.send(message);
        this.terminate();
    }

    private class CommandProcessor
    implements Runnable {
        private ByteBuffer command;
        private SocketProcessorImplNioPooledThread client;

        CommandProcessor(SocketProcessorImplNioPooledThread client, ByteBuffer command) {
            this.command = command;
            this.client = client;
        }

        public void run() {
            if (!this.client.isTerminated()) {
                String com = SocketProcessorImplNioPooledThread.this.codec.decode(this.command).toString();
                if (this.client.getApplication() != null) {
                    this.client.onCommand(com);
                } else {
                    this.client.onInitialize(com);
                }
            }
        }
    }
}

