/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.wda.gpss.Progress;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.util.Finder;
import org.apache.log4j.Priority;

final class SystemCommandSocklet
implements Socklet {
    private SockletDeployInfo info;
    private ExecutableBase server;
    private Progress progress;
    private static final String ALLOW_FLAG_SYSKEY = "gpss.system.SystemCommandSocklet.allowflag";
    private ArrayList clients;
    public static final String RESTART = "restart";
    public static final String SHUTDOWN = "shutdown";
    public static final String RELOAD = "reload";
    public static final String GETLIST = "getSockletsList";

    SystemCommandSocklet() {
    }

    public final void setInfo(ExecutableBase server, SockletDeployInfo info) {
        if (server == null) {
            return;
        }
        if (info != null) {
            this.info = info;
        }
    }

    public final void setMain(ExecutableBase server) {
        if (server != null) {
            this.server = server;
        }
    }

    public final String getName() {
        return this.info.getName();
    }

    public final int getTimeout() {
        return this.info.getTimeout();
    }

    public final void setTimeout(int timeout) {
        this.info.setTimeout(timeout);
    }

    public final List getInitParams(String key) {
        return this.info.getInitParams(key);
    }

    public final synchronized void addClient(SocketProcessor client) {
        this.clients.add(client);
    }

    public final synchronized void removeClient(SocketProcessor client) {
        ((AbstractCollection)this.clients).remove(client);
    }

    public final int countClients() {
        return this.clients.size();
    }

    public final void sendAllToClients(String message) {
        Iterator i = ((AbstractList)new ArrayList(this.clients)).iterator();
        while (i.hasNext()) {
            SocketProcessor client = (SocketProcessor)i.next();
            if (client.send(message)) continue;
            client.terminate();
        }
    }

    public final synchronized void disconnectAllClients(String message) {
        Iterator i = ((AbstractList)new ArrayList(this.clients)).iterator();
        while (i.hasNext()) {
            ((SocketProcessor)i.next()).terminate();
        }
    }

    public void preRemoveClient(SocketProcessor client) {
    }

    public void afterDeployedLinks(Map linkedSocklets) {
    }

    public void destroy() {
    }

    public String deployedBy() {
        return "BySystemServer";
    }

    public void deployedBy(ExecutableBase server, String name) {
    }

    public void sendToAllClients(String message) {
    }

    public void sendToClients(String message, Finder finder) {
    }

    public void sendToClients(String message, String condition) {
    }

    public final boolean allowAccessFromOtherSocklet(Socklet from) {
        return false;
    }

    public final void init(SockletDeployInfo info, List links, Progress progress) {
        this.clients = new ArrayList();
        this.info = info;
        this.progress = progress;
    }

    public void init() {
    }

    public boolean checkConnection(SocketProcessor client) {
        boolean allow = false;
        Iterator it = this.getInitParams("allow").iterator();
        while (it.hasNext()) {
            if (!client.getIPAddress().equals(it.next())) continue;
            allow = true;
            break;
        }
        client.setAttribute((Object)ALLOW_FLAG_SYSKEY, new Boolean(allow));
        client.send(allow ? "+OK" : "-Your connection is not allowed.");
        return allow;
    }

    private boolean getAllowFlag(SocketProcessor client) {
        Boolean result = (Boolean)client.getAttribute(ALLOW_FLAG_SYSKEY);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean doCommand(SocketProcessor client, String command) {
        if (!this.getAllowFlag(client)) {
            return false;
        }
        if (command == null) {
            client.terminate("+God bye...");
            return false;
        }
        if (command.equals(RELOAD)) {
            if (this.server.reloadConfig(this)) {
                client.send("+Reload config successfully!");
            } else {
                client.send("-Reload config failure...");
            }
            return true;
        }
        int restartlen = RESTART.length();
        if (command.length() > restartlen + 2 && command.substring(0, restartlen).equals(RESTART)) {
            String sockletname = command.substring(restartlen + 1);
            if (this.server.restartSocklet(this, sockletname)) {
                client.send("+Restart socklet \"" + sockletname + "\" successfully!");
            } else {
                client.send("-Restart socklet \"" + sockletname + "\" failure...");
            }
            return true;
        }
        if (command.equals(GETLIST)) {
            client.send(this.server.getSockletsList());
            return true;
        }
        if (command.equals(SHUTDOWN)) {
            client.terminate();
            this.server.shutdown(this);
            return false;
        }
        if (command.equals(RESTART)) {
            client.terminate();
            this.server.restart(this);
            return false;
        }
        client.send("-" + command + " is not found.");
        return true;
    }

    public void log(Object message, Priority priority, Throwable throwable) {
    }
}

