package jp.moja.socklet.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import jp.wda.gpss.SocketProcessor;

/**
 * `bg[p[eBeBNX
 * Kw\`bg[\zpNX
 * [ƃ[U[ꗗێ
 * @author Takenori Adachi(TheCoolMuseum)
 */
public class ChatRoom {

	//tB[h////////////////////////////////////////////////////////////////////

	/**
	 * ̃m[h̖O
	 */
	private String name;

	/**
	 * q[i[p}bv
	 */
	private HashMap children;

	/**
	 * e[
	 */
	private ChatRoom parent;

	/**
	 * o[̃Xg
	 */
	private ArrayList members;

	/**
	 * [̊i[p}bv
	 */
	private HashMap attributes;

	/**
	 * VXe[tO
	 * sweepɍ폜邩ǂݒ肵܂
	 */
	private boolean systemRoom;

	public static final String ROOM_ATTRIBUTE_NAME = "__ROOM";

	//RXgN^//////////////////////////////////////////////////////////////////

	/**
	 * RXgN^
	 * @param name
	 * @param system
	 */
	public ChatRoom(String name, boolean system) {
		this.name = name;
		children = new HashMap();
		parent = null;
		members = new ArrayList();
		attributes = new HashMap();
		systemRoom = system;
	}

	/**
	 * RXgN^
	 */
	public ChatRoom() {
		this("", false);
	}

	/**
	 * RXgN^
	 * @param name
	 */
	public ChatRoom(String name) {
		this(name, false);
	}

	//Qb^[Zb^[\bh/////////////////////////////////////////////////////////////

	/**
	 * e[擾
	 * @return
	 */
	public ChatRoom getParent() {
		return parent;
	}

	/**
	 * e[ݒ
	 * @param tree
	 */
	public void setParent(ChatRoom tree) {
		parent = tree;
	}

	/**
	 * O̐ݒ
	 * @param name
	 * @return
	 */
	public ChatRoom setName(String name) {
		this.name = name;
		return this;
	}

	/**
	 * O̎擾
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * VXe[ǂ擾
	 * @return
	 */
	public boolean isSystemRoom() {
		return systemRoom;
	}

	/**
	 * VXe[ǂݒ肷
	 * @param system
	 */
	public void setSystemRoom(boolean system) {
		systemRoom = system;
	}

	//q[擾\bh//////////////////////////////////////////////////////////////

	/**
	 * q[̖OXg擾
	 * @return
	 */
	public List getChildNames() {
		synchronized (children) {
			return new ArrayList(children.keySet());
		}
	}

	/**
	 * q[̗vfXg擾
	 * @return
	 */
	public List getChildValues() {
		synchronized (children) {
			return new ArrayList(children.values());
		}
	}

	/**
	 * q[̃Xg擾
	 * @return
	 */
	public List getChildren() {
		synchronized (children) {
			return new ArrayList(children.entrySet());
		}
	}

	/**
	 * Ow肵Ďq[擾
	 * @param name
	 * @return
	 */
	public ChatRoom getChild(String name) {
		return (ChatRoom)children.get(name);
	}

	//[KwǗ\bh//////////////////////////////////////////////////////////////

	/**
	 * q[̒ǉ
	 * @param name
	 * @param child
	 * @return
	 */
	public ChatRoom addChild(String name, ChatRoom child) {
		synchronized (children) {
			if (children.containsKey(name)) {
				return (ChatRoom)children.get(name);
			}
		}
		ChatRoom oldParent = child.getParent();
		if (oldParent != null) {
			oldParent.removeChild(child);
		}
		synchronized (children) {
			children.put(name, child);
			child.setParent(this);
			child.setName(name);
		}
		return child;
	}

	/**
	 * q[̒ǉ
	 * @param child
	 * @return
	 */
	public ChatRoom addChild(ChatRoom child) {
		return addChild(child.getName(), child);
	}

	/**
	 * q[̒ǉ
	 * @param name
	 * @return
	 */
	public ChatRoom addChild(String name) {
		try {
			return addChild(name, (ChatRoom)getClass().newInstance());
		} catch (Exception e) {
			return addChild(name, new ChatRoom());
		}
	}

	/**
	 * Ow肵Ďq[폜
	 * @param name
	 * @return
	 */
	public ChatRoom removeChild(String name) {
		synchronized (children) {
			ChatRoom node = (ChatRoom)children.remove(name);
			node.setParent(null);
			return node;
		}
	}

	/**
	 * vfw肵Ďq[폜
	 * @param node
	 * @return
	 */
	public ChatRoom removeChild(ChatRoom node) {
		synchronized (children) {
			children.remove(node.getName());
			node.setParent(null);
			return node;
		}
	}

	/**
	 * e[炱̃[̓o^폜
	 * @return
	 */
	public ChatRoom cancelParent() {
		synchronized (children) {
			if (parent != null) {
				parent.removeChild(this);
			}
			return this;
		}
	}

	/**
	 * [gƂȂ郋[擾
	 * @return
	 */
	public ChatRoom getRoot() {
		if (parent != null) {
			return parent.getRoot();
		} else {
			return this;
		}
	}

	//pX\bh/////////////////////////////////////////////////////////////////

	/**
	 * Ŏw肵pX쐬
	 * @param path
	 * @return
	 */
	public ChatRoom makePath(String path) {
		return processPath(path, true);
	}

	/**
	 * Ŏw肵pXT
	 * @param path
	 * @return
	 */
	public ChatRoom searchPath(String path) {
		return processPath(path, false);
	}

	/**
	 * pX̒ǉETs
	 * @param path
	 * @param make
	 * @return
	 */
	private ChatRoom processPath(String path, boolean make) {
		int terminator = path.indexOf("/");

		//pX[̏
		if (terminator == -1) {
			//em[h
			if (path.equals("..")) {
				if (getParent() == null) {
					return this;
				} else {
					return getParent();
				}
			}
			if (make) {
				return addChild(path);
			} else {
				return getChild(path);
			}

		}

		//[g̏
		if (terminator == 0) {
			String nextPath = path.substring(1);
			return getRoot().processPath(nextPath, make);
		}

		//ԃpX̏
		String childName = path.substring(0, terminator);
		String nextPath = path.substring(terminator + 1);
		//em[h
		if (childName.equals("..")) {
			if (getParent() == null) {
				return processPath(nextPath, make);
			} else {
				return getParent().processPath(nextPath, make);
			}
		}
		if (make) {
			ChatRoom child = addChild(childName);
			return child.processPath(nextPath, make);
		} else {
			ChatRoom child = getChild(childName);
			if (child == null) {
				return null;
			} else {
				return child.processPath(nextPath, make);
			}
		}
	}

	/**
	 * ̃[̃[g̃pX𕶎ŏ
	 * @return
	 */
	public String getPathString() {
		String returnPath = "/" + name;
		if (parent == null) {
			return "/";
		}
		return parent.getPathString(returnPath);
	}
	private String getPathString(String path) {
		String returnPath = "/" + name;
		if (parent == null) {
			return path;
		}
		return parent.getPathString(returnPath + path);
	}

	//ގǗ\bh////////////////////////////////////////////////////////////////

	/**
	 * [Ƀ[U[o^
	 * @param client
	 * @return
	 */
	public boolean enter(SocketProcessor client) {
		ChatRoom oldRoom = (ChatRoom)client.getAttribute(ROOM_ATTRIBUTE_NAME);
		if (oldRoom != null) {
			oldRoom.exit(client);
		}
		synchronized (members) {
			if (members.add(client)) {
				client.setAttribute(ROOM_ATTRIBUTE_NAME, this);
				return true;
			} else {
				client.removeAttribute(ROOM_ATTRIBUTE_NAME);
				return false;
			}
		}
	}

	/**
	 * [Ƀ[U[o^
	 * @param path
	 * @param client
	 * @return
	 */
	public boolean enter(String path, SocketProcessor client, boolean make) {
		ChatRoom room;
		if (make) {
			room = makePath(path);
		} else {
			room = searchPath(path);
		}
		if (room != null) {
			return room.enter(client);
		}
		return false;
	}

	/**
	 * [Ƀ[U[o^
	 * @param path
	 * @param client
	 * @return
	 */
	public boolean enter(String path, SocketProcessor client) {
		return enter(path, client, true);
	}

	/**
	 * [ɃIuWFNgo^
	 * @param obj
	 * @return
	 */
	public boolean enter(Object obj) {
		synchronized (members) {
			return members.add(obj);
		}
	}

	/**
	 * [烆[U[폜
	 * @param client
	 * @return
	 */
	public boolean exit(SocketProcessor client) {
		ChatRoom room = (ChatRoom)client.getAttribute(ROOM_ATTRIBUTE_NAME);
		client.removeAttribute(ROOM_ATTRIBUTE_NAME);
		if (room != null && room != this) {
			return room.exit(client);
		} else {
			synchronized (members) {
				return members.remove(client);
			}
		}
	}

	/**
	 * [IuWFNg폜
	 * @param obj
	 * @return
	 */
	public boolean exit(Object obj) {
		synchronized (members) {
			return members.remove(obj);
		}
	}

	/**
	 * [U[̏镔Ԃ
	 * @param client
	 * @return
	 */
	public ChatRoom getRoom(SocketProcessor client) {
		return (ChatRoom)client.getAttribute(ROOM_ATTRIBUTE_NAME);
	}

	//[U[Xg擾\bh////////////////////////////////////////////////////////////

	/**
	 * o[̃Xg擾
	 * @return
	 */
	public List getMemberList() {
		synchronized (members) {
			return new ArrayList(members);
		}
	}

	public List getMemberList(SocketProcessor client) {
		ChatRoom room = (ChatRoom)client.getAttribute(ROOM_ATTRIBUTE_NAME);
		if (room != null) {
			return room.getMemberList();
		} else {
			return new ArrayList();
		}
	}

	/**
	 * o[̐l擾
	 * @return
	 */
	public int getMemberCount() {
		synchronized (members) {
			return members.size();
		}
	}

	//[Ǘ\bh//////////////////////////////////////////////////////////////

	/**
	 * [̐ݒ
	 * @param key
	 * @param value
	 */
	public void setAttribute(Object key, Object value) {
		synchronized (attributes) {
			attributes.put(key, value);
		}
	}

	/**
	 * [̎擾
	 * @param key
	 * @return
	 */
	public Object getAttribute(Object key) {
		synchronized (attributes) {
			return attributes.get(key);
		}
	}

	/**
	 * [̍폜
	 * @param key
	 * @return
	 */
	public Object removeAttribute(Object key) {
		synchronized (attributes) {
			return attributes.remove(key);
		}
	}

	/**
	 * [̑ꗗ擾
	 * @return
	 */
	public List getAttributeKeys() {
		synchronized (attributes) {
			return new ArrayList(attributes.keySet());
		}
	}

	///////////////////////////////////////////////////////////////////////

	public String toString() {
		return getPathString();
	}

	//eXg//////////////////////////////////////////////////////////////////////

	/**
	 * eXgpGg|Cg
	 * @param args
	 */
	public static void main(String[] args) {
		ChatRoom root = new ChatRoom("Root");
		ChatRoom t;
		t = root.makePath("a/b/c/d");
		t.makePath("e");
		t.makePath("f/../g");

		System.out.println(root.getClass());
		System.out.println(root);
		System.out.println(root.searchPath("a/b"));
		System.out.println(t);
		System.out.println(t.getClass());
		System.out.println("----");
		java.util.Iterator itr = t.getChildValues().iterator();
		while (itr.hasNext()) {
			ChatRoom node = (ChatRoom)itr.next();
			System.out.println(node);
		}
	}

}
